/* Buffer tests */

#include "test.h"

#define S1 "This is a very long string that "
#define S2 "goes on and on and on in the hope that "
#define S3 "it will overflow the snprintf() buffer "
#define S4 "and cause the computer to die!"

static char *format(char *fmt, ...);

int
main(void)
{
    vbuffer *b, *b2;
    char *str;
    FILE *fp;
    int val;

    TEST_START("buffer");

    b = vb_create_size(20);
    vb_store(b, "hello");
    TEST("creation", V_STREQ(vb_get(b), "hello"));

    TEST("length", vb_length(b) == 5);

    vb_empty(b);
    TEST("empty", vb_length(b) == 0);

    vb_putc(b, 'a');
    vb_puts(b, "bcdefg");
    vb_putc(b, 'h');
    vb_printf(b, "%s%c%s", "ijkl", 'm', "nopqr");
    vb_puts(b, "stuvwxyz");
    TEST("puts/putc/printf",
         V_STREQ(vb_get(b), "abcdefghijklmnopqrstuvwxyz"));

    vb_destroy(b);
    b = vb_create_size(30);
    vb_printf(b, "%s%s%s%s", S1, S2, S3, S4);
    TEST("extension", V_STREQ(vb_get(b), S1 S2 S3 S4));

    str = format("%s%s%s%s", S1, S2, S3, S4);
    TEST("buffer format macro", V_STREQ(str, S1 S2 S3 S4));

    val = 0;
    if ((fp = fopen(TEST_OUTPUT, "w")) != NULL) {
        vb_fputs(b, fp);
        fclose(fp);
        if ((fp = fopen(TEST_OUTPUT, "r")) != NULL) {
            b2 = vb_create();
            vb_fgets(b2, fp);
            val = V_STREQ(vb_get(b), vb_get(b2));
            fclose(fp);
        }
    }

    TEST("fputs/fgets", val);

    TEST_FINISH;
}

static char *
format(char *fmt, ...)
{
    V_BUF_DECL;
    char *str;
    V_BUF_FMT(fmt, str);
    return str;
}
