/* Copying tests */

#include "test.h"

int
main(void)
{
    vhash *h, *hcopy;
    vmatrix *m;
    vscalar *s;
    char *file;
    vlist *l;

    TEST_START("copy");

#if 0
    h = vh_hash("FOO", V_STRING, "BAR", NULL);

    l = vl_list(V_POINTER, h,
                V_POINTER, h,
                V_POINTER, h,
                V_NULL);

    v_print(l, stdout);
    l = v_copy(l);
    v_print(l, stdout);
#endif

    m = vm_create();
    vm_store(m, 0, 0, 1.0);
    vm_store(m, 1, 1, 1.0);
    vm_store(m, 2, 2, 1.0);

    s = vs_dcreate(3.14159);

    l = vl_list(V_STRING,  "brian",
                V_INT,     -45,
                V_FLOAT,   90.34,
                V_DOUBLE,  1e22,
                V_NULL);

    h = vh_hash("LIST",     V_POINTER,  l,
                "LIST REF", V_POINTER,  l,
                "STRING",   V_STRING,   "fred",
                "INT",      V_INT,      42,
                "REAL",     V_DOUBLE,   11.7,
                "MATRIX",   V_POINTER,  m,
                "SCALAR",   V_POINTER,  s,
                NULL);

    TEST_NOFAIL("copying", (hcopy = v_copy(h)) != NULL);

    TEST("copy value 1", vh_iget(h, "INT") == vh_iget(hcopy, "INT"));
    TEST("copy value 2", vh_iget(h, "REAL") == vh_iget(hcopy, "REAL"));
    TEST("copy value 3", vt_type(vh_pget(hcopy, "LIST")) == vlist_type);
    TEST("copy value 4", vt_type(vh_pget(hcopy, "SCALAR")) == vscalar_type);

    TEST_FINISH;
}
