/* Destruction tests */

#include "test.h"

#define NUM 30

static int destroy_count = 0;

static void
destroy_function(void *ptr)
{
    destroy_count++;
    v_free(ptr);
}

int
main(void)
{
    int *data, i;
    vscalar *s;
    vhash *h;
    vlist *l;
    FILE *fp;

    TEST_START("destroy");

    s = vs_dcreate(3.14159);

    l = vl_list(V_STRING,       "brian",
                V_INT,          45,
                V_FLOAT,        90.34,
                V_DOUBLE,       1e22,
                V_NULL);

    h = vh_hash("STRING",       V_STRING,       "fred",
                "INT",          V_INT,          42,
                "REAL",         V_DOUBLE,       11.7,
                "LIST",         V_POINTER,      l,
                "SCALAR",       V_POINTER,      s,
                NULL);

    vh_pstore(h, "SELF_REFERENCE", h);
    vl_ppush(l, h);

    data = (int *) v_malloc(30 * sizeof(int));
    for (i = 0; i < NUM; i++)
        data[i] = i;

    vl_ppush(l, data);
    v_destroy_with(data, destroy_function);

    if ((fp = fopen(TEST_OUTPUT, "w")) != NULL) {
        v_print(h, fp);
        fclose(fp);
    }

    TEST("destruction", (v_destroy(h), destroy_count == 1));

    TEST_FINISH;
}
