/* Freeze/thaw tests */

#include "test.h"

#define VSIZE 13

int
main(void)
{
    vhash *h, *thaw;
    vmatrix *m;
    vscalar *s;
    vvector *v;
    vlist *l;
    FILE *fp;
    int i;

    TEST_START("freeze");

    s = vs_dcreate(3.14159);

    m = vm_create();
    vm_store(m, 0, 0, 1.0);
    vm_store(m, 1, 1, 1.0);
    vm_store(m, 2, 2, 1.0);

    v = vv_create(VSIZE);
    for (i = 0; i < VSIZE; i++)
        vv_store(v, i, v_randprob());

    l = vl_list(V_STRING,       "brian",
                V_INT,          45,
                V_FLOAT,        90.34,
                V_DOUBLE,       1e22,
                V_NULL);

    h = vh_hash("STRING",       V_STRING,       "fred",
                "INT",          V_INT,          42,
                "REAL",         V_DOUBLE,       11.7,
                "LIST",         V_POINTER,      l,
                "VECTOR",       V_POINTER,      v,
                "SCALAR",       V_POINTER,      s,
                "ANOTHER LIST", V_POINTER,      l,
                "MATRIX",       V_POINTER,      m,
                NULL);

    vv_freeze_format("%.2f");
    vv_freeze_linesize(12);

    if ((fp = fopen(TEST_OUTPUT, "w")) == NULL)
        TEST_FAIL("can't open output file");

    fprintf(fp, "# This is a comment line, which should be ignored.\n\n");
    TEST_NOFAIL("freezing", v_freeze(h, fp));
    fclose(fp);

    if ((fp = fopen(TEST_OUTPUT, "r")) == NULL)
        TEST_FAIL("can't open input file");
    TEST("thawing", (thaw = v_thaw(fp)) != NULL);
    fclose(fp);

    if (thaw == NULL) {
        fprintf(stderr, "Thaw error: %s\n", v_thaw_error());
        TEST_ABORT;
    }

    TEST("thaw value 1", vh_iget(h, "INT") == vh_iget(thaw, "INT"));
    TEST("thaw value 2", vh_iget(h, "REAL") == vh_iget(thaw, "REAL"));
    TEST("thaw value 3", vt_type(vh_pget(thaw, "LIST")) == vlist_type);
    TEST("thaw value 4", vt_type(vh_pget(thaw, "SCALAR")) == vscalar_type);

    TEST("thaw file",
         (h = v_thaw_file(TEST_INPUT)) != NULL);

    TEST_FINISH;
}
