/* Hash tests */

#include "test.h"

int
main(void)
{
    vhash *h, *h2;
    vlist *l;

    TEST_START("hash");

    h = vh_hash("STRING",       V_STRING,       "fred",
                "INT",          V_INT,          42,
                "REAL",         V_DOUBLE,       11.7,
                NULL);
    TEST("creation", vh_entry_count(h) == 3);

    h2 = vh_copy(h);
    TEST("copy", vh_entry_count(h2) == 3);

    vh_undef(h2, "INT");
    TEST("undef", vh_entry_count(h2) == 3 && !vh_defined(h2, "INT"));

    vh_delete(h2, "INT");
    TEST("delete", vh_entry_count(h2) == 2);

    TEST("exists", vh_exists(h2, "STRING"));

    vh_empty(h2);
    TEST("empty", vh_entry_count(h2) == 0);

    l = vh_sortkeys(h, NULL);
    TEST("sortkeys", V_STREQ(vl_sget(l, 0), "INT"));

    l = vh_sortvalues(h, NULL);
    TEST("sortvalues", V_STREQ(vl_sget(l, 0), "11.7"));

    TEST_FINISH;
}
