/* Image tests */

#include "test.h"

#define WIDTH  100
#define HEIGHT 70

#define X 20
#define Y 30

#define R 255
#define G 128
#define B 0

int
main(void)
{
    vimage *im, *copy, *pgm, *ppm, *rgb;
    unsigned char val, r, g, b;
    char *file;
    FILE *fp;

    TEST_START("image");

    /* Basic tests */
    TEST_NOFAIL("creating image", im = vi_create(WIDTH, HEIGHT));

    TEST("setting gray value", vi_set_gray(im, X, Y, G));

    TEST("getting it back", vi_get_gray(im, X, Y, &val) && val == G);

    TEST("getting gray data", vi_get_graydata(im) != NULL);

    TEST("getting RGB data", vi_get_rgbdata(im) != NULL);

    TEST("setting RGB value", vi_set_rgb(im, X, Y, R, G, B));

    TEST("getting it back",
         vi_get_rgb(im, X, Y, &r, &g, &b) &&
         r == R && g == G && b == B);

    TEST("copying", copy = vi_copy(im));

    TEST("destruction", (vi_destroy(copy), 1));

    TEST("deleting gray data", (vi_delete_gray(im), 1));

    /* Read/write PGM */
    file = TEST_INPUT_FILE("pgm");
    if ((fp = fopen(file, "r")) == NULL)
        TEST_FAIL("can't open input file");
    TEST_NOFAIL("reading PGM from file", pgm = vi_read_pgm(fp));
    fclose(fp);

    file = TEST_OUTPUT_FILE("pgm");
    if ((fp = fopen(file, "w")) == NULL)
        TEST_FAIL("can't open output file");
    TEST("writing PGM to file", vi_write_pgm(pgm, fp));
    fclose(fp);

    /* Read/write PPM */
    file = TEST_INPUT_FILE("ppm");
    if ((fp = fopen(file, "r")) == NULL)
        TEST_FAIL("can't open input file");
    TEST_NOFAIL("reading PPM from file", ppm = vi_read_ppm(fp));
    fclose(fp);

    file = TEST_OUTPUT_FILE("ppm");
    if ((fp = fopen(file, "w")) == NULL)
        TEST_FAIL("can't open output file");
    TEST("writing PPM to file", vi_write_ppm(ppm, fp));
    fclose(fp);

    /* Read/write SGI */
    file = TEST_INPUT_FILE("sgi");
    if ((fp = fopen(file, "r")) == NULL)
        TEST_FAIL("can't open input file");
    TEST_NOFAIL("reading SGI from file", rgb = vi_read_sgi(fp));
    fclose(fp);

    file = TEST_OUTPUT_FILE("sgi");
    if ((fp = fopen(file, "w")) == NULL)
        TEST_FAIL("can't open output file");
    TEST("writing SGI to file", vi_write_sgi(rgb, fp));
    fclose(fp);

    /* Read/write generic images */
    file = TEST_INPUT_FILE("gif");
    TEST_NOFAIL("reading image from file",
                im = vi_read_file(file, NULL));

    file = TEST_OUTPUT_FILE("jpeg");
    TEST_NOFAIL("writing image to file",
                vi_write_file(im, file, NULL));

    /* Read/write raw data */
    vi_compress(im, 1);

    file = TEST_OUTPUT_FILE("dat");
    if ((fp = fopen(file, "w")) == NULL)
        TEST_FAIL("can't open output file");
    TEST("writing image to raw file", v_fwrite(im, fp));
    fclose(fp);

    if ((fp = fopen(file, "r")) == NULL)
        TEST_FAIL("can't open output file");
    TEST("reading image from raw file", im = v_fread(fp));
    fclose(fp);

    /* Freeze/thaw */
    file = TEST_OUTPUT_FILE("txt");
    if ((fp = fopen(file, "w")) == NULL)
        TEST_FAIL("can't open output file");
    TEST_NOFAIL("freezing image to file", v_freeze(im, fp));
    fclose(fp);

    if ((fp = fopen(file, "r")) == NULL)
        TEST_FAIL("can't open output file");
    TEST("thawing image from file", im = v_thaw(fp));
    fclose(fp);

    TEST_FINISH;
}
