/* Binary I/O tests */

#include "test.h"

#define SVAL 98
#define UVAL 230

int
main(void)
{
    unsigned short ushort = UVAL;
    unsigned char uchar = UVAL;
    unsigned int uint = UVAL;
    short sshort = SVAL;
    char schar = SVAL;
    int sint = SVAL;
    FILE *fp;

    TEST_START("io");

    /* Write some values to file */
    if ((fp = fopen(TEST_OUTPUT, "w")) != NULL) {
        /* Unsigned */
        fwrite(&uchar, sizeof(unsigned char), 1, fp);
        fwrite(&ushort, sizeof(unsigned short), 1, fp);
        fwrite(&uint, sizeof(unsigned int), 1, fp);

        /* Signed */
        fwrite(&schar, sizeof(char), 1, fp);
        fwrite(&sshort, sizeof(short), 1, fp);
        fwrite(&sint, sizeof(int), 1, fp);

        fclose(fp);
    } else {
        TEST_FAIL("can't write output file");
    }

    /* Read them back */
    if ((fp = fopen(TEST_OUTPUT, "r")) == NULL)
        TEST_FAIL("can't read output file");

    /* Unsigned */
    TEST("reading unsigned char",
         v_read_char(&uchar, fp) && uchar == UVAL);

    TEST("reading unsigned short",
         v_read_short(&ushort, fp) && ushort == UVAL);

    TEST("reading unsigned int",
         v_read_int(&uint, fp) && uint == UVAL);

    /* Signed */
    TEST("reading signed char",
         v_read_char(&schar, fp) && schar == SVAL);

    TEST("reading signed short",
         v_read_short(&sshort, fp) && sshort == SVAL);

    TEST("reading signed int",
         v_read_int(&sint, fp) && sint == SVAL);

    TEST_FINISH;
}
