/* List tests */

#include "test.h"

static char *letters[] = {
    "A", "B", "C", "D", "E", "F", "G", NULL
};

int
main(void)
{
    vlist *l, *l2, *l3;
    int i, val;
    char *str;

    TEST_START("list");

    /* Basic functions */
    l = vl_create();
    vl_ipush(l, 33);
    val = vl_ipop(l);
    TEST("push/pop", val == 33);

    vl_dpush(l, 10.1);
    vl_spush(l, "foo");
    vl_ipush(l, 555);
    TEST("length", vl_length(l) == 3);

    TEST("get", V_STREQ(vl_sgetref(l, 1), "foo"));

    l2 = vl_copy(l);
    for (val = 0, i = 0; i < vl_length(l); i++)
        if (!vs_equal(vl_get(l, i), vl_get(l2, i)))
            val = 1;
    TEST("copy", val == 0);

    TEST("shift", vl_dshift(l2) == 10.1 && vl_length(l2) == 2);

    vl_iunshift(l2, 99);
    TEST("unshift", vl_iget(l2, 0) == 99);

    vl_empty(l2);
    TEST("empty", !vl_defined(l2, 0));

    TEST("head", vl_dhead(l) == 10.1);

    TEST("tail", vl_itail(l) == 555);

    /* Split/join functions */
    l = vl_split("this is a test string", NULL);
    TEST("split 1", vl_length(l) == 5 &&
         V_STREQ(vl_sgetref(l, 3), "test"));

    l = vl_split("this is a test string", "i");
    TEST("split 2", vl_length(l) == 4 &&
         V_STREQ(vl_sgetref(l, 3), "ng"));

    l = vl_nsplit("1 2 3  5  7", " ");
    TEST("split 3", vl_length(l) == 7 &&
         vl_iget(l, 4) == 5);

    l = vl_qsplit("this is a 'quoted string'", " ", "'");
    TEST("split 4", vl_length(l) == 4 &&
         V_STREQ(vl_sgetref(l, 3), "quoted string"));

    str = vl_join(l, "X");
    TEST("join", V_STREQ(str, "thisXisXaXquoted string"));

    /* List functions */
    l = vl_list(V_INT, 23,
                V_FLOAT, 33.1,
                V_STRING, "fred",
                V_INT, 10,
                V_NULL);
    TEST("list creation", vl_length(l) == 4 && vl_iget(l, 3) == 10);

    l2 = vl_list(V_INT, 5,
                 V_STRING, "bill",
                 V_NULL);

    l3 = vl_concat(l, l2);
    TEST("concat", vl_length(l3) == 6 && vl_iget(l3, 4) == 5);

    vl_append(l, l2);
    TEST("append", vl_length(l) == 6 && vl_iget(l, 4) == 5);

    l = vl_makelist(letters);
    TEST("makelist", vl_length(l) == 7 && V_STREQ(vl_sgetref(l, 2), "C"));

    l2 = vl_list(V_STRING, "X",
                 V_STRING, "Y",
                 V_STRING, "Z",
                 V_NULL);
    l3 = vl_splice(l, 2, 4, l2);
    TEST("splice",
         V_STREQ(vl_sgetref(l, 4), "Z") &&
         V_STREQ(vl_sgetref(l, 5), "G") &&
         V_STREQ(vl_sgetref(l3, 3), "F"));

    /* Sort/search functions */
    l = vl_list(V_STRING, "Derek",
                V_STRING, "clive",
                V_STRING, "brian",
                V_STRING, "Aaron",
                V_NULL);
    vl_sort_inplace(l, vs_casecmp);
    TEST("sort", V_STREQ(vl_sgetref(l, 2), "clive"));

    val = vl_ssearch(l, "zondo", vs_casecmp, 0);
    TEST("search 1", val == V_GREATER);

    val = vl_ssearch(l, "zondo", vs_casecmp, 1);
    TEST("search 2", val == V_NOTFOUND);

    val = vl_ssearch(l, "brian", vs_casecmp, 0);
    TEST("search 3", val == 1);

    val = vl_ssearch(l, "brian", vs_casecmp, 1);
    TEST("search 4", val == 1);

    /* Other functions */
    l2 = vl_reverse(l);
    TEST("reverse", V_STREQ(vl_sgetref(l2, 0), "Derek"));

    l2 = vl_combine(l, 2);
    TEST("combine", vl_length(l2) == 6);

    l2 = vl_permute(l, 2);
    TEST("permute", vl_length(l2) == 12);

    TEST_FINISH;
}
