/* Macro function tests */

#include "test.h"

int
main(int argc, char *argv[])
{
    V_NBUF_DECL(mybuf);
    V_BUF_DECL;

    TEST_START("macros");

    V_BUF_SET("foo");
    TEST("setting string", V_STREQ(V_BUF_VAL, "foo"));

    V_BUF_ADD("bar");
    TEST("adding string", V_STREQ(V_BUF_VAL, "foobar"));

    V_BUF_SET2("%s %d", "fred", 2);
    TEST("setting formatted string", V_STREQ(V_BUF_VAL, "fred 2"));

    V_BUF_ADD1(" %03d", 45);
    TEST("adding formatted string", V_STREQ(V_BUF_VAL, "fred 2 045"));

    V_NBUF_SET(mybuf, "brian");
    TEST("setting named buffer", V_STREQ(V_NBUF_VAL(mybuf), "brian"));

    TEST("buffer independence", V_STREQ(V_BUF_VAL, "fred 2 045"));

    TEST_FINISH;
}
