/* Matrix tests */

#include "test.h"

#define ROW 45
#define COL 65

int
main(void)
{
    int row, col;
    vmatrix *m;
    FILE *fp;

    TEST_START("matrix");

    TEST("creation", m = vm_create_size(6, 2));

    TEST("setting a value", (vm_store(m, 3, 2, 4.0), 1));

    TEST("getting it back", vm_get(m, 3, 2) == 4.0);

    TEST("requirement", (vm_store(m, ROW, COL, 1.0), 1));

    TEST("reallocation", (vm_get(m, ROW, COL) == 1.0));

    if ((fp = fopen(TEST_OUTPUT, "w")) == NULL)
        TEST_FAIL("can't open output file");
    TEST("freezing matrix to file", v_freeze(m, fp));
    fclose(fp);

    if ((fp = fopen(TEST_OUTPUT, "r")) == NULL)
        TEST_FAIL("can't open output file");
    TEST("thawing matrix from file", m = v_thaw(fp));
    fclose(fp);

    TEST("rows", vm_rows(m) == ROW + 1);

    TEST("columns", vm_columns(m) == COL + 1);

    TEST("destruction", (vm_destroy(m), 1));

    TEST_FINISH;
}
