/* Memory function tests */

#include "test.h"

#define S1 "This is a very long string that "
#define S2 "goes on and on and on in the hope that "
#define S3 "it will overflow the snprintf() buffer "
#define S4 "and cause the computer to die!"

#define D1 4
#define D2 5
#define D3 3
#define D4 2

static char *
format(char *fmt, ...)
{
    char *str;
    V_ALLOCA_FMT(str, fmt);
    return strdup(str);
}

int
main(int argc, char *argv[])
{
    float ****array = NULL;
    int d1, d2, d3, d4;
    char *str;

    TEST_START("memory");

    V_ALLOC_4D(array, float, D1, D2, D3, D4);
    TEST("allocating 4D array", array != NULL);

    for (d1 = 0; d1 < D1; d1++)
        for (d2 = 0; d2 < D2; d2++)
            for (d3 = 0; d3 < D3; d3++)
                for (d4 = 0; d4 < D4; d4++)
                    array[d1][d2][d3][d4] = d1 + d2 + d3 + d4;

    TEST("setting array values", 1);

    V_DEALLOC_4D(array, D1, D2, D3, D4);
    TEST("deallocating array", array == NULL);

    str = format("%s%s%s%s", S1, S2, S3, S4);
    TEST("formatted string allocation", V_STREQ(str, S1 S2 S3 S4));

    TEST_FINISH;
}
