/* Parser tests */

#include "test.h"

#define CHECK(expr, result) eval(p, expr, result, fp)

#define DEBUG_ON  yy_vars_debug = 1
#define DEBUG_OFF yy_vars_debug = 0

static int eval(vparser *p, char *expr, double result, FILE *fp);

int
main(void)
{
    extern int yy_vars_debug;
    vparser *p;
    FILE *fp;

    TEST_START("parser");

    if ((fp = fopen(TEST_OUTPUT, "w")) == NULL)
        TEST_ABORT;

    TEST("creating parser", (p = vp_create()) != NULL);

    TEST("addition",         CHECK("2 + 2", 4));
    TEST("subtraction",      CHECK("5 - 2", 3));
    TEST("multiplication",   CHECK("5 * 4", 20));
    TEST("division",         CHECK("999999 / 7", 142857));
    TEST("exponentiation",   CHECK("2 ^ 10", 1024));
    TEST("equality",         CHECK("13 == 13", 1));
    TEST("inequality",       CHECK("13 != 14", 1));
    TEST("greater than",     CHECK("14 > 8", 1));
    TEST("boolean and",      CHECK("1 < 2 && 3 > 2", 1));
    TEST("boolean or",       CHECK("1 < 2 || 3 < 2", 1));
    TEST("ternary operator", CHECK("2 + 2 == 4 ? 1 : -1", 1));
    TEST("remainder",        CHECK("49 % 4", 1));
    TEST("parentheses",      CHECK("2 * (1 + 5)", 12));
    TEST("setting variable", CHECK("x = 34", 34));
    TEST("getting variable", CHECK("x + 3", 37));
    TEST("undef variable",   CHECK("z + 3", 3));
    TEST("sqrt function",    CHECK("sqrt(49)", 7));
    TEST("max function",     CHECK("max(3, 2.2, 5.6, 10)", 10));
    TEST("preset constants", CHECK("pi > 3.14 && e > 2.718", 1));

    TEST("destroying parser", (vp_destroy(p), 1));

    fclose(fp);
    TEST_FINISH;
}

static int
eval(vparser *p, char *expr, double result, FILE *fp)
{
    if (vp_eval(p, expr)) {
        fprintf(fp, "%s -> %g\n", expr, vp_dvalue(p));
        return (vp_dvalue(p) == result);
    }

    fprintf(fp, "%s -> %s\n", expr, vp_error(p));
    return 0;
}
