/* Regexp tests */

#include "test.h"

int
main(void)
{
    vlist *list, *matched;
    char *subst;
    vregex *r;

    TEST_START("regexp");

    r = vr_create(" *\\([a-z]+\\)");
    TEST("creation", r != NULL);

    TEST("match 1", !vr_match("   123", r));

    TEST("match 2", vr_match("   foo", r));

    TEST("matched", V_STREQ(vr_matched(1), "foo"));

    subst = vr_subst("123   foo", r, "bar");
    TEST("subst", V_STREQ(subst, "123bar"));

    list = vl_list(V_STRING, "foo",
                   V_STRING, "bar",
                   V_STRING, "baz",
                   V_NULL);

    r = vr_create("ba");
    matched = vr_grep(list, r);
    TEST("grep", vl_length(matched) == 2);

    TEST_FINISH;
}
