/* Scalar tests */

#include "test.h"

int
main(void)
{
    vscalar *s, *s2;

    TEST_START("scalar");

    s = vs_create(V_UNDEF);
    TEST("undef value", !vs_defined(s));

    vs_istore(s, 23);
    TEST("integer value", vs_iget(s) == 23);

    vs_fstore(s, 23.5);
    TEST("float value", vs_fget(s) == 23.5);

    vs_dstore(s, 46.8);
    TEST("double value", vs_dget(s) == 46.8);

    vs_sstore(s, "hello");
    TEST("string value", V_STREQ(vs_sgetref(s), "hello"));

    s2 = vs_copy(s);
    TEST("copying", V_STREQ(vs_sgetref(s2), "hello"));

    TEST("equality", vs_equal(s, s2));

    TEST("type access", vs_type(s) == V_STRING);

    vs_undef(s2);
    TEST("undefining", !vs_defined(s2));

    TEST_FINISH;
}
