/* System function tests */

#include "test.h"

int
main(void)
{
    vlist *proc;
    FILE *fp;
    int t;

    TEST_START("system");

    TEST("checking existence",
         v_test("/usr/bin", V_TEST_EXISTS));

    TEST("checking file",
         v_test("/bin/ls", V_TEST_FILE));

    TEST("checking directory",
         v_test("/usr/local/bin", V_TEST_DIR));

    TEST("getting filename part",
         V_STREQ(v_filename("/usr/local/bin"), "bin"));

    TEST("getting dirname part",
         V_STREQ(v_dirname("/usr/local/bin"), "/usr/local"));

    TEST("getting process information",
         (proc = vl_procinfo()) != NULL);

    if ((fp = fopen(TEST_OUTPUT, "w")) != NULL) {
        v_freeze(proc, fp);
        fclose(fp);
    } else {
        TEST_FAIL("can't open output file");
    }

    TEST("date parsing",
         (t = v_parse_date("tomorrow")) > 0);

    TEST_FINISH;
}
