/* Traversal tests */

#include "test.h"

static FILE *output_fp;

static int
traverse_function(void *ptr)
{
    fprintf(output_fp, "%s (0x%x)", vt_ptrname(ptr), ptr);
    if (v_traverse_seen(ptr))
        fprintf(output_fp, " (seen before)");
    fprintf(output_fp, "\n");
    return 0;
}

int
main(void)
{
    vscalar *s;
    vhash *h;
    vlist *l;

    TEST_START("traverse");

    TEST_NOFAIL("opening output",
                ((output_fp = fopen(TEST_OUTPUT, "w")) != NULL));

    s = vs_dcreate(3.14159);

    l = vl_list(V_STRING,       "brian",
                V_INT,          45,
                V_FLOAT,        90.34,
                V_DOUBLE,       1e22,
                V_NULL);

    h = vh_hash("STRING",       V_STRING,       "fred",
                "INT",          V_INT,          42,
                "REAL",         V_DOUBLE,       11.7,
                "LIST",         V_POINTER,      l,
                "SCALAR",       V_POINTER,      s,
                "LIST2",        V_POINTER,      l,
                "SCALAR2",      V_POINTER,      s,
                NULL);

    vh_pstore(h, "HASH", h);

    fprintf(output_fp, "Data structure:\n\n");
    v_print(h, output_fp);
    fprintf(output_fp, "\nTraversal:\n\n");

    TEST("traversal", v_traverse(h, traverse_function) == 0);

    fclose(output_fp);

    TEST_FINISH;
}
