/* Vector tests */

#include "test.h"

#define SIZE 23

int
main(void)
{
    float *values, last_val, val;
    vvector *v, *v2;
    int i, sorted;

    TEST_START("vector");

    TEST("creating explicitly",
         (v = vv_create_vector(2, 1.2, 4.4)) != NULL);

    vv_store(v, 1, 5.3);
    val = vv_get(v, 1);
    TEST("setting a value", V_ABS(val - 5.3) < 0.000001);

    TEST("destroying",
         (vv_destroy(v), 1));

    values = V_ALLOC(float, SIZE);
    for (i = 0; i < SIZE; i++)
	values[i] = v_randprob();

    TEST("creating with values",
         (v = vv_create_with_values(SIZE, values)) != NULL);

    TEST("creating from values",
         (v2 = vv_create_from_values(SIZE, values)) != NULL);

    TEST("destroying again",
         (vv_destroy(v2), 1));

    TEST("copying",
         (v2 = vv_copy(v)) != NULL);

    /* Sort, and make sure its sorted */
    vv_sort(v);

    for (i = 0, sorted = 1; i < SIZE; i++) {
        val = vv_get(v, i);

        if (i == 0 || val >= last_val) {
            last_val = val;
        } else {
	    sorted = 0;
	    break;
	}
    }

    TEST("sorting", sorted);

    TEST_FINISH;
}
