/* Binary I/O tests */

#include "test.h"

int
main(void)
{
    vhash *h, *hread, *hcopy;
    vmatrix *m;
    vscalar *s;
    char *file;
    vlist *l;
    FILE *fp;

    TEST_START("write");

    m = vm_create();
    vm_store(m, 0, 0, 1.0);
    vm_store(m, 1, 1, 1.0);
    vm_store(m, 2, 2, 1.0);

    s = vs_dcreate(3.14159);

    l = vl_list(V_STRING,       "brian",
                V_INT,          -45,
                V_FLOAT,        90.34,
                V_DOUBLE,       1e22,
                V_NULL);

    h = vh_hash("STRING",       V_STRING,       "fred",
                "INT",          V_INT,          42,
                "REAL",         V_DOUBLE,       11.7,
                "LIST",         V_POINTER,      l,
                "SCALAR",       V_POINTER,      s,
                "ANOTHER LIST", V_POINTER,      l,
                "MATRIX",       V_POINTER,      m,
                NULL);

    if ((fp = fopen(TEST_OUTPUT, "w")) == NULL)
        TEST_FAIL("can't open output file");
    TEST_NOFAIL("writing", v_fwrite(h, fp));
    fclose(fp);

    if (v_exists(TEST_INPUT))
        file = TEST_INPUT;
    else
        file = TEST_OUTPUT;

    if ((fp = fopen(file, "r")) == NULL)
        TEST_FAIL("can't open input file");
    TEST_NOFAIL("reading", (hread = v_fread(fp)) != NULL);
    fclose(fp);

    TEST("read value 1", vh_iget(h, "INT") == vh_iget(hread, "INT"));
    TEST("read value 2", vh_iget(h, "REAL") == vh_iget(hread, "REAL"));
    TEST("read value 3", vt_type(vh_pget(hread, "LIST")) == vlist_type);
    TEST("read value 4", vt_type(vh_pget(hread, "SCALAR")) == vscalar_type);

    TEST_NOFAIL("copying", (hcopy = v_fcopy(h)) != NULL);

    TEST("copy value 1", vh_iget(h, "INT") == vh_iget(hcopy, "INT"));
    TEST("copy value 2", vh_iget(h, "REAL") == vh_iget(hcopy, "REAL"));
    TEST("copy value 3", vt_type(vh_pget(hcopy, "LIST")) == vlist_type);
    TEST("copy value 4", vt_type(vh_pget(hcopy, "SCALAR")) == vscalar_type);

    TEST_FINISH;
}
