/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package com.sun.iiim;

import java.text.AttributedString;
import java.text.AttributedCharacterIterator;

/**
 * This class represents InputMethod's status event.
 */
public class IIIMStatusEvent extends IIIMEvent {

    private AttributedCharacterIterator iterator;
    private String statusString;

    public static final int START = 0;
    public static final int DRAW  = 1;
    public static final int DONE  = 2;

    /**
     * Constructor for START/DONE event
     *
     * @param	IIIMStatusEvent.START or IIIMStatusEvent.DONE
     */
    public IIIMStatusEvent(int type) {
	super(STATUS);
	if (type != START && type != DONE) {
	    throw new IllegalArgumentException();
	}
	this.type = type;
    }

    /**
     * Constructor for DRAW event
     *
     * @param 	IIIMStatusEvent.DRAW
     * @param	character iterator which represents status string
     */
    public IIIMStatusEvent(int type, AttributedCharacterIterator iterator) {
	super(STATUS);
	if (type != DRAW) {
	    throw new IllegalArgumentException();
	}
	this.type = DRAW;
	this.iterator = iterator;
    }

    /**
     * Constructor for DRAW event
     */
    public IIIMStatusEvent(int type, String statusString) {
	super(STATUS);
	if (type != DRAW) {
	    throw new IllegalArgumentException();
	}
	this.type = DRAW;
	this.statusString = statusString;
    }

    public AttributedCharacterIterator getIterator() {
	if (iterator == null) {
	    iterator = new AttributedString(statusString).getIterator();
	}
	return iterator;
    }

    public String getString() {
	if (statusString == null) {
	    statusString = iteratorToString(iterator);
	}
	return statusString;
    }
}
