#include <config.h>
#include <stdio.h>
#include "IMUser.hh"
#include "IMLog.hh"

IMDesktop*
IMUser::request_desktop(
    IMDesktop::IMDesktopAttr &attr
)
{
    IMDesktop *pd;
    IMDesktopList::iterator it;

    for (it = desklist.begin(); it != desklist.end(); it++) {
	pd = *it;
	if (pd->match(attr)) {
	    LOG_DEBUG("Found the existing desktop:%s",
		      pd->get_desktop_display_name().c_str());
	    return pd;
	}
    }
    pd = new IMDesktop(this, attr);
    LOG_DEBUG("Create new IMDesktop for %s",
	      pd->get_desktop_display_name().c_str());
    if (!pd) return NULL;
    desklist.push_back(pd);

    return pd;
}



IMUser::IMUser(
    const u16string &x_username
)
{
    username = x_username;
}

IMUser::~IMUser()
{
    delete_all(desklist);
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
