/*
 * iml_fop.h: IIIMF iml file operation - public header file
 */

#if !defined(IIIMF_IML_FOP_H)
#define IIIMF_IML_FOP_H

#include <dirent.h>
#include <utime.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/uio.h>

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

typedef void *	(* iml_fop_get_function_t)(const char *);

typedef void *	(* iml__fopc_create_t)(const char *, int , void *);
typedef void	(* iml__fopc_free_t)(void *);

typedef int	(* iml_fop_open_t)(void *, const char *, int, ...);
typedef ssize_t	(* iml_fop_read_t)(void *, int, void *, size_t);
typedef ssize_t	(* iml_fop_readv_t)(void *,
				    int, const struct iovec *, int);
typedef ssize_t	(* iml_fop_write_t)(void *, int, const void *, size_t);
typedef ssize_t	(* iml_fop_writev_t)(void *, int,
				     const struct iovec *, int);
typedef int	(* iml_fop_close_t)(void *, int);
typedef int	(* iml_fop_creat_t)(void *, const char *, mode_t);
typedef off_t	(* iml_fop_lseek_t)(void *, int, off_t, int);
typedef int	(* iml_fop_stat_t)(void *, const char *, struct stat *);
typedef int	(* iml_fop_lstat_t)(void *, const char *, struct stat *);
typedef int	(* iml_fop_fstat_t)(void *, int, struct stat *);
typedef int	(* iml_fop_mkdir_t)(void *, const char *, mode_t);
typedef int	(* iml_fop_rmdir_t)(void *, const char *);
typedef int	(* iml_fop_symlink_t)(void *, const char *, const char *);
typedef int	(* iml_fop_readlink_t)(void *,
				       const char *, char *, size_t);
typedef int	(* iml_fop_link_t)(void *, const char *, const char *);
typedef int	(* iml_fop_unlink_t)(void *, const char *);
typedef int	(* iml_fop_rename_t)(void *, const char *, const char *);
typedef int	(* iml_fop_fcntl_t)(void *, int, int, ...);
typedef int	(* iml_fop_truncate_t)(void *, const char *, off_t);
typedef int	(* iml_fop_ftruncate_t)(void *, int, off_t);
typedef DIR *	(* iml_fop_opendir_t)(void *, const char *);
typedef struct dirent *
		(* iml_fop_readdir_t)(void *, DIR *);
typedef int	(* iml_fop_closedir_t)(void *, DIR *);
typedef int	(* iml_fop_access_t)(void *, const char *, int);
typedef int	(* iml_fop_chmod_t)(void *, const char *, mode_t);
typedef int	(* iml_fop_fchmod_t)(void *, int, mode_t);
typedef int	(* iml_fop_chown_t)(void *, const char *, uid_t, gid_t);
typedef int	(* iml_fop_lchown_t)(void *, const char *, uid_t, gid_t);
typedef int	(* iml_fop_fchown_t)(void *, int, uid_t, gid_t);
typedef long	(* iml_fop_fpathconf_t)(void *, int, int);
typedef long	(* iml_fop_pathconf_t)(void *, const char *, int);
typedef int	(* iml_fop_utime_t)(void *,
				    const char *, const struct utimbuf *);
typedef int	(* iml_fop_utimes_t)(void *, char *, struct timeval *);

#define IML_FOPC_TYPE_LE	(0)
#define IML_FOPC_TYPE_DESKTOP	(1)

/* compatibility */
#define IML_NSC_TYPE_LE		(0)
#define IML_NSC_TYPE_DESKTOP	(1)

#if defined(__cplusplus)
}
#endif /* __cplusplus */

#endif /* !IIIMF_IML_FOP_H */
