#!/bin/sh

DIRNAME=`dirname $0`

BASEDIR=`cd ${DIRNAME}; pwd`
VARDIR=`cd ${BASEDIR}; pwd`/var/data
UDSFILE=`cd ${BASEDIR}; pwd`/var/udsfile

IIIMD=${DIRNAME}/../../iiimsf/src/.libs/iiimd
CLIENT=${BASEDIR}/.libs/client

[ -d ${VARDIR} ] || mkdir -p ${VARDIR}

IFOPT="-ifpath_name ${BASEDIR}/.libs -if fop_test.so"

IIIMD_OPTION_DESKTOP=t
IIIMD_OPTION_UDSFILE=${UDSFILE}
IIIMD_OPTION_VARDIR=${VARDIR}
IIIMD_NSFIO_ALT=t

export IIIMD_OPTION_DESKTOP
export IIIMD_OPTION_UDSFILE
export IIIMD_OPTION_VARDIR
export IIIMD_NSFIO_ALT

${IIIMD} -d -nodaemon ${IFOPT} -desktop -udsfile ${UDSFILE} &

IIIMDPID="$!"

sleep 2

${CLIENT}

ps -p ${IIIMDPID} > /dev/null 2>&1 && kill ${IIIMDPID}

exit 0