/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-2001.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

#ifndef __GTK_FLAT_BUTTON_H__
#define __GTK_FLAT_BUTTON_H__


#include <gdk/gdk.h>
#include <gtk/gtkbin.h>
#include <gtk/gtkenums.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GTK_TYPE_FLAT_BUTTON                 (gtk_flat_button_get_type ())
#define GTK_FLAT_BUTTON(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_FLAT_BUTTON, GtkFlatButton))
#define GTK_FLAT_BUTTON_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_FLAT_BUTTON, GtkFlatButtonClass))
#define GTK_IS_FLAT_BUTTON(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_FLAT_BUTTON))
#define GTK_IS_FLAT_BUTTON_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FLAT_BUTTON))
#define GTK_FLAT_BUTTON_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_FLAT_BUTTON, GtkFlatButtonClass))

typedef struct _GtkFlatButton        GtkFlatButton;
typedef struct _GtkFlatButtonClass   GtkFlatButtonClass;

struct _GtkFlatButton
{
  GtkBin bin;

  GdkWindow *event_window;

  gchar *label_text;

  guint activate_timeout;

  guint constructed : 1;
  guint in_button : 1;
  guint button_down : 1;
  guint relief : 2;
  guint use_underline : 1;
  guint use_stock : 1;
  guint depressed : 1;
  guint depress_on_activate : 1;
  guint focus_on_click : 1;
};

struct _GtkFlatButtonClass
{
  GtkBinClass        parent_class;
  
  void (* pressed)  (GtkFlatButton *button);
  void (* released) (GtkFlatButton *button);
  void (* clicked)  (GtkFlatButton *button);
  void (* enter)    (GtkFlatButton *button);
  void (* leave)    (GtkFlatButton *button);
  void (* activate) (GtkFlatButton *button);
  
  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GType          gtk_flat_button_get_type          (void) G_GNUC_CONST;
GtkWidget*     gtk_flat_button_new               (void);
GtkWidget*     gtk_flat_button_new_with_label    (const gchar    *label);
GtkWidget*     gtk_flat_button_new_from_stock    (const gchar    *stock_id);
GtkWidget*     gtk_flat_button_new_with_mnemonic (const gchar    *label);
void           gtk_flat_button_pressed           (GtkFlatButton      *button);
void           gtk_flat_button_released          (GtkFlatButton      *button);
void           gtk_flat_button_clicked           (GtkFlatButton      *button);
void           gtk_flat_button_enter             (GtkFlatButton      *button);
void           gtk_flat_button_leave             (GtkFlatButton      *button);

void                  gtk_flat_button_set_relief         (GtkFlatButton      *button,
						     GtkReliefStyle  newstyle);
GtkReliefStyle        gtk_flat_button_get_relief         (GtkFlatButton      *button);
void                  gtk_flat_button_set_label          (GtkFlatButton      *button,
						     const gchar    *label);
G_CONST_RETURN gchar *gtk_flat_button_get_label          (GtkFlatButton      *button);
void                  gtk_flat_button_set_use_underline  (GtkFlatButton      *button,
						     gboolean        use_underline);
gboolean              gtk_flat_button_get_use_underline  (GtkFlatButton      *button);
void                  gtk_flat_button_set_use_stock      (GtkFlatButton      *button,
						     gboolean        use_stock);
gboolean              gtk_flat_button_get_use_stock      (GtkFlatButton      *button);
void                  gtk_flat_button_set_focus_on_click (GtkFlatButton      *button,
						     gboolean        focus_on_click);
gboolean              gtk_flat_button_get_focus_on_click (GtkFlatButton      *button);
void                  gtk_flat_button_set_alignment      (GtkFlatButton      *button,
						     gfloat          xalign,
						     gfloat          yalign);
void                  gtk_flat_button_get_alignment      (GtkFlatButton      *button,
						     gfloat         *xalign,
						     gfloat         *yalign);


void _gtk_flat_button_set_depressed             (GtkFlatButton     *button,
					    gboolean       depressed);
void _gtk_flat_button_paint                     (GtkFlatButton     *button,
					    GdkRectangle  *area,
					    GtkStateType   state_type,
					    GtkShadowType  shadow_type,
					    const gchar   *main_detail,
					    const gchar   *default_detail);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_FLAT_BUTTON_H__ */
