#ifndef _IM_KEYS_H
#define _IM_KEYS_H

#define IME_VK_ENTER          '\n'
#define IME_VK_BACK_SPACE     '\b'
#define IME_VK_TAB            '\t'
#define IME_VK_CANCEL         0x03
#define IME_VK_CLEAR          0x0C
#define IME_VK_SHIFT          0x10
#define IME_VK_CONTROL        0x11
#define IME_VK_ALT            0x12
#define IME_VK_PAUSE          0x13
#define IME_VK_CAPS_LOCK      0x14
#define IME_VK_ESCAPE         0x1B
#define IME_VK_SPACE          0x20
#define IME_VK_PAGE_UP        0x21
#define IME_VK_PAGE_DOWN      0x22
#define IME_VK_END            0x23
#define IME_VK_HOME           0x24
#define IME_VK_LEFT           0x25
#define IME_VK_UP             0x26
#define IME_VK_RIGHT          0x27
#define IME_VK_DOWN           0x28
#define IME_VK_COMMA          0x2C
#define IME_VK_MINUS          0x2D
#define IME_VK_PERIOD         0x2E
#define IME_VK_SLASH          0x2F
#define IME_VK_0              0x30
#define IME_VK_1              0x31
#define IME_VK_2              0x32
#define IME_VK_3              0x33
#define IME_VK_4              0x34
#define IME_VK_5              0x35
#define IME_VK_6              0x36
#define IME_VK_7              0x37
#define IME_VK_8              0x38
#define IME_VK_9              0x39
#define IME_VK_SEMICOLON      0x3B
#define IME_VK_EQUALS         0x3D
#define IME_VK_A              0x41
#define IME_VK_B              0x42
#define IME_VK_C              0x43
#define IME_VK_D              0x44
#define IME_VK_E              0x45
#define IME_VK_F              0x46
#define IME_VK_G              0x47
#define IME_VK_H              0x48
#define IME_VK_I              0x49
#define IME_VK_J              0x4A
#define IME_VK_K              0x4B
#define IME_VK_L              0x4C
#define IME_VK_M              0x4D
#define IME_VK_N              0x4E
#define IME_VK_O              0x4F
#define IME_VK_P              0x50
#define IME_VK_Q              0x51
#define IME_VK_R              0x52
#define IME_VK_S              0x53
#define IME_VK_T              0x54
#define IME_VK_U              0x55
#define IME_VK_V              0x56
#define IME_VK_W              0x57
#define IME_VK_X              0x58
#define IME_VK_Y              0x59
#define IME_VK_Z              0x5A
#define IME_VK_OPEN_BRACKET   0x5B
#define IME_VK_BACK_SLASH     0x5C
#define IME_VK_CLOSE_BRACKET  0x5D
#define IME_VK_NUMPAD0        0x60
#define IME_VK_NUMPAD1        0x61
#define IME_VK_NUMPAD2        0x62
#define IME_VK_NUMPAD3        0x63
#define IME_VK_NUMPAD4        0x64
#define IME_VK_NUMPAD5        0x65
#define IME_VK_NUMPAD6        0x66
#define IME_VK_NUMPAD7        0x67
#define IME_VK_NUMPAD8        0x68
#define IME_VK_NUMPAD9        0x69
#define IME_VK_MULTIPLY       0x6A
#define IME_VK_ADD            0x6B
#define IME_VK_SEPARATER      0x6C
#define IME_VK_SUBTRACT       0x6D
#define IME_VK_DECIMAL        0x6E
#define IME_VK_DIVIDE         0x6F
#define IME_VK_DELETE         0x7F /* ASCII DEL */
#define IME_VK_NUM_LOCK       0x90
#define IME_VK_SCROLL_LOCK    0x91
#define IME_VK_F1             0x70
#define IME_VK_F2             0x71
#define IME_VK_F3             0x72
#define IME_VK_F4             0x73
#define IME_VK_F5             0x74
#define IME_VK_F6             0x75
#define IME_VK_F7             0x76
#define IME_VK_F8             0x77
#define IME_VK_F9             0x78
#define IME_VK_F10            0x79
#define IME_VK_F11            0x7A
#define IME_VK_F12            0x7B
#define IME_VK_F13            0xF000
#define IME_VK_F14            0xF001
#define IME_VK_F15            0xF002
#define IME_VK_F16            0xF003
#define IME_VK_F17            0xF004
#define IME_VK_F18            0xF005
#define IME_VK_F19            0xF006
#define IME_VK_F20            0xF007
#define IME_VK_F21            0xF008
#define IME_VK_F22            0xF009
#define IME_VK_F23            0xF00A
#define IME_VK_F24            0xF00B
#define IME_VK_PRINTSCREEN    0x9A
#define IME_VK_INSERT         0x9B
#define IME_VK_HELP           0x9C
#define IME_VK_META           0x9D
#define IME_VK_BACK_QUOTE     0xC0
#define IME_VK_QUOTE          0xDE
#define IME_VK_KP_UP          0xE0
#define IME_VK_KP_DOWN        0xE1
#define IME_VK_KP_LEFT        0xE2
#define IME_VK_KP_RIGHT       0xE3
#define IME_VK_DEAD_GRAVE               0x80
#define IME_VK_DEAD_ACUTE               0x81
#define IME_VK_DEAD_CIRCUMFLEX          0x82
#define IME_VK_DEAD_TILDE               0x83
#define IME_VK_DEAD_MACRON              0x84
#define IME_VK_DEAD_BREVE               0x85
#define IME_VK_DEAD_ABOVEDOT            0x86
#define IME_VK_DEAD_DIAERESIS           0x87
#define IME_VK_DEAD_ABOVERING           0x88
#define IME_VK_DEAD_DOUBLEACUTE         0x89
#define IME_VK_DEAD_CARON               0x8a
#define IME_VK_DEAD_CEDILLA             0x8b
#define IME_VK_DEAD_OGONEK              0x8c
#define IME_VK_DEAD_IOTA                0x8d
#define IME_VK_DEAD_VOICED_SOUND        0x8e
#define IME_VK_DEAD_SEMIVOICED_SOUND    0x8f
#define IME_VK_AMPERSAND                0x96
#define IME_VK_ASTERISK                 0x97
#define IME_VK_QUOTEDBL                 0x98
#define IME_VK_LESS                     0x99
#define IME_VK_GREATER                  0xa0
#define IME_VK_BRACELEFT                0xa1
#define IME_VK_BRACERIGHT               0xa2
#define IME_VK_AT                       0x0200
#define IME_VK_COLON                    0x0201
#define IME_VK_CIRCUMFLEX               0x0202
#define IME_VK_DOLLAR                   0x0203
#define IME_VK_EURO_SIGN                0x0204
#define IME_VK_EXCLAMATION_MARK         0x0205
#define IME_VK_INVERTED_EXCLAMATION_MARK 0x0206
#define IME_VK_LEFT_PARENTHESIS         0x0207
#define IME_VK_NUMBER_SIGN              0x0208
#define IME_VK_PLUS                     0x0209
#define IME_VK_RIGHT_PARENTHESIS        0x020A
#define IME_VK_UNDERSCORE               0x020B
#define IME_VK_FINAL                    0x0018
#define IME_VK_CONVERT                  0x001C
#define IME_VK_NONCONVERT               0x001D
#define IME_VK_ACCEPT                   0x001E
#define IME_VK_MODECHANGE               0x001F
#define IME_VK_KANA                     0x0015
#define IME_VK_KANJI                    0x0019
#define IME_VK_ALPHANUMERIC             0x00F0
#define IME_VK_KATAKANA                 0x00F1
#define IME_VK_HIRAGANA                 0x00F2
#define IME_VK_FULL_WIDTH               0x00F3
#define IME_VK_HALF_WIDTH               0x00F4
#define IME_VK_ROMAN_CHARACTERS         0x00F5
#define IME_VK_ALL_CANDIDATES           0x0100
#define IME_VK_PREVIOUS_CANDIDATE       0x0101
#define IME_VK_CODE_INPUT               0x0102
#define IME_VK_JAPANESE_KATAKANA        0x0103
#define IME_VK_JAPANESE_HIRAGANA        0x0104
#define IME_VK_JAPANESE_ROMAN           0x0105
#define IME_VK_CUT                      0xFFD1
#define IME_VK_COPY                     0xFFCD
#define IME_VK_PASTE                    0xFFCF
#define IME_VK_UNDO                     0xFFCB
#define IME_VK_AGAIN                    0xFFC9
#define IME_VK_FIND                     0xFFD0
#define IME_VK_PROPS                    0xFFCA
#define IME_VK_STOP                     0xFFC8
#define IME_VK_COMPOSE                  0xFF20
#define IME_VK_ALT_GRAPH                0xFF7E
#define IME_VK_UNDEFINED                0x0

#define	IME_SHIFT_MASK	        (1 << 0)
#define	IME_CTRL_MASK	        (1 << 1)
#define	IME_META_MASK	        (1 << 2)
#define	IME_ALT_MASK	        (1 << 3)
#define	IME_ALT_GRAPH_MASK	(1 << 5)
#define	IME_BUTTON1_MASK	(1 << 4)
#define	IME_BUTTON2_MASK	ALT_MASK
#define	IME_BUTTON3_MASK	META_MASK

#endif
