#ifndef _PALETTE_AUX_H_
#define _PALETTE_AUX_H_

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "vkb_aux.h"
#include "property_window.h"

enum {
    BUTTON_ID_DRAG = 0,
    BUTTON_ID_IME,
    BUTTON_ID_QJBJ,
    BUTTON_ID_PUNCT,
    BUTTON_ID_VKB,
    BUTTON_ID_UTILITY,
    BUTTONS_NUM
};

enum {
    PIXMAP_ID_DEFAULT_IME = 0,
    PIXMAP_ID_DRAGAREA_VERTICAL,
    PIXMAP_ID_DRAGAREA_HORIZONTAL,
    PIXMAP_ID_HALFWIDTH,
    PIXMAP_ID_FULLWIDTH,
    PIXMAP_ID_ENPUNCT,
    PIXMAP_ID_CNPUNCT,
    PIXMAP_ID_VKB,
    PIXMAP_ID_UTILITY,
    PIXMAPS_NUM
};

enum {
    SHOW_STYLE_HORIZONTAL = 0,
    SHOW_STYLE_VERTICAL
};

enum {
    IME_DRAW_ICON_ONLY,
    IME_DRAW_TEXT_ONLY,
    IME_DRAW_BOTH_ICON_TEXT,
};

#define DATA_PALETTE_AUX_WINDOW_INFO	"palette_window_info"

typedef struct _palette_button_t {
    int button_id;

    int x;
    int y;
    int width;
    int height;

    gboolean enabled;
    gboolean activated;
    gboolean pressed;
    gboolean focused;

    gpointer data;
} palette_button_t;

typedef struct _palette_window_t {
    GtkWidget *window;
    GtkWidget *drawing_area;
    GdkPixmap *pixmap;

    PangoContext *context;
    PangoLayout *pango_layout;
    PangoFontDescription *font_desc;

    GdkPixbuf *pixbufs[PIXMAPS_NUM];

    GtkTooltips *tooltips;
    GdkCursor   *moving_cursor;
    GdkCursor   *normal_cursor;

    GtkWidget *ime_list_menu;
    ime_module_t *current_ime;
    int ime_draw_style;

    GtkWidget *vkb_list_menu;
    int vkb_layout_list_inited;
    vkb_layout_t **vkb_layout_list;
    vkb_layout_t *current_vkb_layout;

    vkb_window_t *vkb_window;
    gboolean     vkb_show_status;
    
    property_data_t   *property_data;
    property_window_t *property_window;
    guint             timer_save_properties;

    GtkWidget *utility_list_menu;
    GtkWidget *utility_menuitem_show_vertical;

    GtkWidget *about_dialog;

    palette_button_t buttons[BUTTONS_NUM];
    palette_button_t *pressed_button;
    palette_button_t *focused_button;

    gint show_style;

    gint show_status;
    gint qjbj_status;
    gint punct_status;

    gboolean menu_popuped;

    gint width;
    gint height;

    gint pos_x;
    gint pos_y;

    gboolean draging;
    gboolean draw_draging_frame;
    gint drag_x_start;
    gint drag_y_start;
    gint drag_x_save;
    gint drag_y_save;
} palette_window_t;

typedef struct _palette_session_t {
    int pos_x;
    int pos_y;
    int show_status;
    int qjbj_status;
    int punct_status;
    char *ime_uuid;
} palette_session_t;

#endif				/* _PALETTE_AUX_H_ */
