/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

/*
 * header files for SunIM library
 */
#include "SunIM.h"
#include "SunIMMMan.h"
#include "SunIMProt.h"
#include "SunIMMthd.h"
#include "SunIMPriv.h"
#include "SunIMCore.h"
#include "SunIMPub.h"

/*
 * define If method prototype
 */
Bool if_template_OpenIF(iml_if_t *);
Bool if_template_CloseIF(iml_if_t *);
Bool if_template_GetIFValues(iml_if_t *, IMArgList, int);
Bool if_template_SetIFValues(iml_if_t *, IMArgList, int);
Bool if_template_OpenDesktop(iml_desktop_t *, IMArgList, int);
Bool if_template_CloseDesktop(iml_desktop_t *);
Bool if_template_CreateSC(iml_session_t*, IMArgList, int);
Bool if_template_DestroySC(iml_session_t *);
Bool if_template_GetSCValues(iml_session_t *, IMArgList, int);
Bool if_template_SetSCValues(iml_session_t *, IMArgList, int);
IMText *if_template_ResetSC(iml_session_t *);
void if_template_SetSCFocus(iml_session_t *);
void if_template_UnsetSCFocus(iml_session_t *);
void if_template_SendEvent(iml_session_t *, IMInputEvent * ev);

/*
 * define if_methods_t
 */
static if_methods_t if_methods = {
    if_template_OpenIF,
    if_template_CloseIF,
    if_template_GetIFValues,
    if_template_SetIFValues,
    if_template_OpenDesktop,
    if_template_CloseDesktop,
    if_template_CreateSC,
    if_template_DestroySC,
    if_template_GetSCValues,
    if_template_SetSCValues,
    if_template_ResetSC,
    if_template_SetSCFocus,
    if_template_UnsetSCFocus,
    if_template_SendEvent
};

/*
 * define Human Readable Name as UTFCHAR for LE
 */
UTFCHAR lename_string[] = {
    0x30c6,
    0x30f3,
    0x30d7,
    0x30ec,
    0x30fc,
    0x30c8,
    0x30a8,
    0x30f3,
    0x30b8,
    0x30f3,
0};

/*
 * define Human Readable Name as UTFCHAR for language
 */
UTFCHAR jahrn_string[] = {
    0x65e5,
    0x672c,
    0x8a9e,
0};

static IMLEName lename = {
    "template",			/* LE id */
    lename_string		/* LE HRN */
};

static IMLocale locales[] = {
    {
        "ja",			/* locale id */
        jahrn_string		/* locale HRN */
    },
    NULL
};

#ifdef WIN32
#define EXPORT extern __declspec(dllexport)

EXPORT

#endif

void
if_GetIfInfo(
    IMArgList args,
    int num_args
)
{
    int i;
#ifdef	DEBUG
    printf("if_GetIfInfo()\n");
    printf("	This method is invoked when htt_server retrieves\n");
    printf("	if_method_t method table.\n\n");
#endif
    for (i = 0; i < num_args; i++, args++) {
        switch (args->id) {
            case IF_VERSION:
                args->value = (IMArgVal) "1.2";
                break;
            case IF_METHOD_TABLE:
                args->value = (IMArgVal) & if_methods;
                break;
            case IF_LE_NAME:
                args->value = (IMArgVal) & lename;
                break;
            case IF_SUPPORTED_LOCALES:
                args->value = (IMArgVal) & locales;
                break;
            case IF_SUPPORTED_OBJECTS:
                break;
            case IF_NEED_THREAD_LOCK:
                args->value = (IMArgVal) False;
                break;
            default:
                break;
            }
    }
}

Bool
if_template_OpenIF(
    iml_if_t * If
)
{
    printf("if_template_OpenIF()\n");
    printf("	This method is invoked when the Language Engine\n");
    printf("	is started to use by htt_server\n\n");
    return True;
}

Bool
if_template_CloseIF(
    iml_if_t * If
)
{
    printf("if_template_CloseIF()\n");
    printf("	This method is invoked when htt_server stops to\n");
    printf("	to use the Language Engine, which means there is\n");
    printf("	no client of the Language Engine is used.\n\n");
    return True;
}



Bool
if_template_GetIFValues(
    iml_if_t * If,
    IMArgList args,
    int num_args
)
{
    int i;
    
    printf("if_template_GetIFValues()\n");
    printf("	This method is invoked when the Language Engine\n");
    printf("	wants to set IF attributes of IM Client.\n\n");
    return True;
}

Bool
if_template_SetIFValues(
    iml_if_t * If,
    IMArgList args,
    int num_args
)
{
    printf("if_template_SetIFValues()\n");
    printf("	This method is invoked when the IM client\n");
    printf("	wants to set IF attributes.\n\n");
    
    return True;
}

Bool
if_template_OpenDesktop(
    iml_desktop_t * desktop,
    IMArgList args,
    int num_args
)
{
    int i;

    printf("if_template_OpenDesktop()\n");
    printf("	This method is invoked when the user start to use\n");
    printf("	the desktop, which means the first connection.\n");
    
    printf("\n");
    printf("	user [%s@%s] is entered\n",
        desktop->user_name,
        desktop->host_name);
    printf("\n");

    printf("	The additional info of IM client are\n");

    for (i = 0; i < num_args; i++, args++) {
        switch (args->id) {
            case UI_USER_NAME:
                if (args->value) {
                    printf("	UI_USER_NAME=%s\n", args->value);
                }
                break;
            case UI_HOST_NAME:
                if (args->value) {
                    printf("	UI_HOST_NAME=%s\n", args->value);
                }
                break;
            case UI_DISPLAY_ID:
                if (args->value) {
                    printf("	UI_DISPLAY_ID=%s\n", args->value);
                }
                break;
            case UI_PROTOCOL_TYPE:
                if (args->value) {
                    printf("	UI_PROTOCOL_TYPE=%s\n", args->value);
                }
                break;
            case UI_CLIENT_TYPE:
                if (args->value) {
                    printf("	UI_CLIENT_TYPE=%s\n", args->value);
                }
                break;
            case UI_XSERVER_VENDOR:
                if (args->value) {
                    printf("	UI_XSERVER_VENDOR=%s\n", args->value);
                }
                break;
            case UI_OS_NAME:
                if (args->value) {
                    printf("	UI_OS_NAME=%s\n", args->value);
                }
                break;
            case UI_OS_ARCH:
                if (args->value) {
                    printf("	UI_OS_ARCH=%s\n", args->value);
                }
                break;
            case UI_OS_VERSION:
                if (args->value) {
                    printf("	UI_OS_VERSION=%s\n", args->value);
                }
                break;
            }
    }
    
    return True;
}

Bool
if_template_CloseDesktop(
    iml_desktop_t * desktop
)
{
    printf("if_template_CloseDesktop()\n");
    printf("	This method is invoked when the user exits from\n");
    printf("	the desktop, which means there is no IM client\n");
    printf("	for the user.\n");
    
    printf("\n");
    printf("	user [%s@%s] exited\n",
        desktop->user_name,
        desktop->host_name);
    printf("\n");
    return True;
}

Bool
if_template_CreateSC(
    iml_session_t *s,
    IMArgList args,
    int num_args
)
{
    int i;
    iml_desktop_t *desktop = s->desktop;

    printf("if_template_CreateSC()\n");
    printf("	This method is invoked when a session is created\n");
    
    printf("\n");
    printf("	Creating a session for user [%s@%s]\n",
        desktop->user_name,
        desktop->host_name);
    printf("\n");

    printf("	The additional info of IM client are\n");

    for (i = 0; i < num_args; i++, args++) {
        switch (args->id) {
            case UI_USER_NAME:
                if (args->value) {
                    printf("	UI_USER_NAME=%s\n", args->value);
                }
                break;
            case UI_HOST_NAME:
                if (args->value) {
                    printf("	UI_HOST_NAME=%s\n", args->value);
                }
                break;
            case UI_DISPLAY_ID:
                if (args->value) {
                    printf("	UI_DISPLAY_ID=%s\n", args->value);
                }
                break;
            case UI_PROTOCOL_TYPE:
                if (args->value) {
                    printf("	UI_PROTOCOL_TYPE=%s\n", args->value);
                }
                break;
            case UI_CLIENT_TYPE:
                if (args->value) {
                    printf("	UI_CLIENT_TYPE=%s\n", args->value);
                }
                break;
            case UI_XSERVER_VENDOR:
                if (args->value) {
                    printf("	UI_XSERVER_VENDOR=%s\n", args->value);
                }
                break;
            case UI_OS_NAME:
                if (args->value) {
                    printf("	UI_OS_NAME=%s\n", args->value);
                }
                break;
            case UI_OS_ARCH:
                if (args->value) {
                    printf("	UI_OS_ARCH=%s\n", args->value);
                }
                break;
            case UI_OS_VERSION:
                if (args->value) {
                    printf("	UI_OS_VERSION=%s\n", args->value);
                }
                break;
            }
    }
    
    return True;
}

Bool
if_template_DestroySC(
    iml_session_t * s
)
{
    printf("if_template_DestroySC(s=0x%x)\n", s);
    printf("	This method is invoked when the session is\n");
    printf("	being destroyed.\n");
    
    printf("\n");
    printf("	Destroying the session %x of user [%s@%s]\n",
        s,
        s->desktop->user_name,
        s->desktop->host_name);
    printf("\n");
    
    return True;
}

Bool
if_template_GetSCValues(
    iml_session_t * s,
    IMArgList args,
    int num_args
)
{
    int i;
    IMArg *p = args;

    printf("if_template_GetSCValues(s=0x%x)\n", s);
    printf("	This method is invoked when the Language Engine\n");
    printf("	wants to set SC attributes of IM Client.\n\n");
    
    for (i = 0; i < num_args; i++, p++) {
        switch (p->id) {
            default:
                break;
            }
    }
    return True;
}

Bool
if_template_SetSCValues(
    iml_session_t * s,
    IMArgList args,
    int num_args
)
{
    int i;
    IMArg *p = args;
    
    printf("if_template_SetSCValues(s=0x%x)\n", s);
    printf("	This method is invoked when the IM client\n");
    printf("	wants to set SC attributes.\n\n");
    
    for (i = 0; i < num_args; i++, p++) {
        switch (p->id) {
            case SC_TRIGGER_ON_NOTIFY:
                printf("	SC_TRIGGER_ON_NOTIFY: received\n");
                break;
            case SC_TRIGGER_OFF_NOTIFY:
                printf("	SC_TRIGGER_OFF_NOTIFY: received\n");
                break;
            case SC_REALIZE:
		if(s->desktop->session_count == 1){
			printf("	SC_REALIZE: just after OpenDesktop\n");
		} else {
			printf("	SC_REALIZE: received\n");
		}
                break;
            default:
                break;
            }
    }
    printf("\n");
    return True;
}

IMText *
if_template_ResetSC(
    iml_session_t * s
)
{
    printf("if_template_ResetSC(s=0x%x)\n", s);
    printf("	This method is invoked when the IM client\n");
    printf("	wants to reset the IC.\n\n");
    
    return (IMText *) NULL;
}

void
if_template_SetSCFocus(
    iml_session_t * s
)
{
    printf("if_template_SetSCFocus(s=0x%x)\n", s);
    printf("	This method is invoked when the IM client\n");
    printf("	gets the input focus.\n\n");
}

void
if_template_UnsetSCFocus(
    iml_session_t * s
)
{
    printf("if_template_UnsetSCFocus(s=0x%x)\n", s);
    printf("	This method is invoked when the IM client\n");
    printf("	loses the input focus.\n\n");
}

void
if_template_SendEvent(
    iml_session_t * s,
    IMInputEvent * ev
)
{
    printf("if_template_SendEvent(s=0x%x,ev=%x)\n", s, ev);
    printf("	This method is invoked when any event occurs\n");
    printf("	on the IM client.\n\n");
    
    if (ev->type == IM_EventKeyList) {
        IMKeyListEvent *keylistevent = (IMKeyListEvent *) ev;
        IMKeyEventStruct *key = (IMKeyEventStruct *) keylistevent->keylist;
        printf("	received keyevent keycode=0x%x,keychar=0x%x,state=%x\n",
            key->keyCode,
            key->keyChar,
            key->modifier);
    }
}
