#!/usr/bin/sh
#
# $Id: verify.sh,v 1.1.1.1.2.1 2001/03/15 07:52:17 himi Exp $
#
# @(#)verify.sh 1.2	99/05/26 SMI
#
# Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions: The above copyright notice and this
# permission notice shall be included in all copies or substantial
# portions of the Software.
# 
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
# FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
# CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
# THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
# ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.
# 
# 
# Except as contained in this notice, the names of The Open Group and/or
# Sun Microsystems, Inc. shall not be used in advertising or otherwise to
# promote the sale, use or other dealings in this Software without prior
# written authorization from The Open Group and/or Sun Microsystems,
# Inc., as applicable.
# 
# 
# X Window System is a trademark of The Open Group
# 
# OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
# logo, LBX, X Window System, and Xinerama are trademarks of the Open
# Group. All other trademarks and registered trademarks mentioned herein
# are the property of their respective owners. No right, title or
# interest in or to any trademark, service mark, logo or trade name of
# Sun Microsystems, Inc. or its licensors is granted.

ME=`basename $0`

LOCALE_LIST=
LOCALE_LIST_DEFAULT="${LANG}"
LOCALE_LIST_JP="ja ja_JP.PCK ja_JP.UTF-8"
LOCALE_LIST_KR="ko ko.UTF-8"
LOCALE_LIST_ZH="zh zh.GBK"
LOCALE_LIST_TW="zh_TW zh_TW.BIG5"
LOCALE_LIST_ALL="${LOCALE_LIST_JP} ${LOCALE_LIST_KR} ${LOCALE_LIST_ZH} ${LOCALE_LIST_TW}"

ENCODING_LIST="CompoundText MultiByte UTF-16 WideChar"
DATA_DIR=data

PURPOSE=check
VERBOSE=

usage() {
    exec >&2
    echo "Usage: ${ME} [-i] [-L] [-t] [-v] [-h] [-l locale]"
    exit $1
}

usage_help() {
    exec >&2
    echo "Usage: ${ME} [-i] [-L] [-t] [-v] [-l locale]"
    echo "       ${ME} -h"
    echo "options:"
    echo "       -l LOCALE  verify csconv on LOCALE."
    echo "       -L         verify csconv on all locales."
    echo "       -t         run bcheck command on csconv."
    echo "                  log files will be saved in directory \"log\"."
    echo "       -v         verbose."
    echo "       -i         create data files from existing MultiByte data file"
    echo "                  in directory \"${DATA_DIR}\"."
    echo "       -h         print this help."
    exit $1
}

do_check() {
    for loc in ${LOCALE_LIST}; do
	for enc_from in ${ENCODING_LIST}; do
	    for enc_to in ${ENCODING_LIST}; do
		data_in=${DATA_DIR}/${loc}-${enc_from}
		data_out=${DATA_DIR}/${loc}-${enc_to}
		./csconv -l ${loc} -f ${enc_from} -t ${enc_to} ${data_in} |
		cmp - ${data_out}
		if [ $? -eq 0 ]; then
		    if [ "${VERBOSE}" ]; then
			echo "${loc}/${enc_from}/${enc_to}: pass"
		    fi
		else
		    echo "${loc}/${enc_from}/${enc_to}: fail"
		fi
	    done
	done
    done
}

do_bcheck() {
    test -d log || mkdir log
    for loc in ${LOCALE_LIST}; do
	for enc_from in ${ENCODING_LIST}; do
	    for enc_to in ${ENCODING_LIST}; do
		data_in=${DATA_DIR}/${loc}-${enc_from}
		log=log/${loc}-${enc_from}-${enc_to}
		bcheck -all -o ${log} \
		./csconv -l ${loc} -f ${enc_from} -t ${enc_to} -o /dev/null ${data_in}
	    done
	done
    done
}

do_data() {
    test -d ${DATA_DIR} || mkdir ${DATA_DIR}
    enc_from=MultiByte
    for loc in ${LOCALE_LIST}; do
	data_in=${DATA_DIR}/${loc}-${enc_from}
	for enc_to in CompoundText UTF-16 WideChar
	do
	    data_out=${DATA_DIR}/${loc}-${enc_to}
	    ./csconv -l ${loc} -f ${enc_from} -t ${enc_to} -o ${data_out} ${data_in}
	done
    done
}

set -- `getopt iLl:tvh "$@"`

if [ $? -ne 0 ]; then
    usage 2
fi

while [ $# -gt 0 ]; do    
    case "${1}" in
    -L) LOCALE_LIST="${LOCALE_LIST} ${LOCALE_LIST_ALL}"; shift;;
    -i) PURPOSE=data; shift;;
    -l) LOCALE_LIST="${LOCALE_LIST} $2"; shift 2;;
    -t) PURPOSE=bcheck; shift;;
    -v)	VERBOSE=yes; shift;;
    -h) usage_help 0; shift;;
    --)	shift; break;;
    *)	echo "${ME}: invalid option: \"$1\""; usage 2;;
    esac
done


if [ x"${LOCALE_LIST}" = x ]; then
    LOCALE_LIST="${LOCALE_LIST_DEFAULT}"
fi

case "${PURPOSE}" in
 check) do_check;;
bcheck) do_bcheck;;
  data) do_data;;
     *) echo "${ME}: unknown purpose: ${PURPOSE}"; usege 3;;
esac
