#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <iiimp.h>

#include "iiimp-dataP.h"

int
iiimp_data_s_get_protocol_version(
    IIIMP_data_s * data_s
)
{
    return data_s->protocol_version;
}

IIIMF_status
iiimp_data_s_limit_protocol_version(
    IIIMP_data_s * data_s,
    int version
)
{
    if (version > data_s->protocol_version)
	return IIIMF_STATUS_PROTOCOL_VERSION;
    data_s->protocol_version = version;

    return IIIMF_STATUS_SUCCESS;
}

IIIMP_data_s*
iiimp_data_s_with_protocol_version_new(
    int protocol_version
)
{
    IIIMP_data_s *	data_s;

    if (protocol_version >= 0x100) {
	return NULL;
    }

    data_s = (IIIMP_data_s *)malloc(sizeof (IIIMP_data_s));
    if (NULL == data_s) return NULL;
    data_s->byte_swap = 0;
    data_s->attribute_id = NULL;
    data_s->status = 0;
    data_s->print_fp = stdout;
    data_s->print_flag = 0;
    data_s->protocol_version = protocol_version;

    return data_s;
}

IIIMP_data_s *
iiimp_data_s_new(void)
{
    return iiimp_data_s_with_protocol_version_new(3);
}

void
iiimp_data_s_delete(IIIMP_data_s * data_s)
{
    if (NULL == data_s) return;
    (void)iiimp_data_print_fp(data_s, NULL);
    (void)iiimp_attribute_id_destroy(data_s);
    free(data_s);
}


FILE *
iiimp_data_print_fp(IIIMP_data_s * data_s, FILE * fp)
{
    if (NULL == data_s) return NULL;
    data_s->print_fp = fp;
    return data_s->print_fp;
}


uint_t
iiimp_data_print_flag(IIIMP_data_s * data_s, uint_t print_flag)
{
    if (IIIMP_PRINT_QUERY != print_flag) {
	data_s->print_flag = print_flag;
    }
    return data_s->print_flag;
}


int
iiimp_data_status(IIIMP_data_s * data_s)
{
    return data_s->status;
}


IIIMP_card16
iiimp_attribute_id_search(IIIMP_data_s * data_s, IIIMP_card16 id_dynamic)
{
    IIIMP_attribute_id *	attr;

    for (attr = data_s->attribute_id; NULL != attr; attr = attr->next) {
	if (id_dynamic == attr->id_dynamic) {
	    return attr->id_predefined;
	}
    }

    return 0;
}


void
iiimp_attribute_id_update(
    IIIMP_data_s *	data_s,
    IIIMP_card16	id_predefined,
    IIIMP_card16	id_dynamic)
{
    IIIMP_attribute_id *	attr;

    for (attr = data_s->attribute_id; NULL != attr; attr = attr->next) {
	if (id_dynamic == attr->id_dynamic) {
	    attr->id_predefined = id_predefined;
	    return;
	}
    }
    attr = (IIIMP_attribute_id *)malloc(sizeof (IIIMP_attribute_id));
    if (NULL == attr) return;
    attr->id_predefined = id_predefined;
    attr->id_dynamic = id_dynamic;
    attr->next = data_s->attribute_id;
    data_s->attribute_id = attr;

    return;
}


void
iiimp_attribute_id_destroy(IIIMP_data_s * data_s)
{
    IIIMP_attribute_id *	attr;
    IIIMP_attribute_id *	attr_next;

    for (attr = data_s->attribute_id; NULL != attr; attr = attr_next) {
	attr_next = attr->next;
	free(attr);
    }
    data_s->attribute_id = NULL;

    return;
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
