/* GIMLET: GNOME Input Method Language Enabing Tool
 *
 * Copyright (C) 2001, 2002 Havoc Pennington
 * Copyright (C) 2002 Red Hat, Inc.
 * Copyright (C) 2003 Sun Microsystems
 * Copyright (C) 2003 Mariano Suarez-Alvarez
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GIMLET_UTILS_H
#define __GIMLET_UTILS_H

#include <glade/glade.h>

void gimlet_util_show_error_dialog (GtkWindow *transient_parent,
				    GtkWidget **weak_ptr,
				    const char *message_format, ...);
void gimlet_util_show_help (const char *topic, 
			    GtkWindow  *transient_parent);
void gimlet_util_set_unique_role (GtkWindow *window, const char *prefix);

GladeXML* gimlet_util_load_glade_file (const char *filename,
				       const char *widget_root,
				       GtkWindow  *error_dialog_parent);
#endif
