/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package sun.awt.im.iiimp;

import java.awt.*;
import java.awt.im.*;
import java.awt.font.*;
//For testing
import java.text.*;
import com.sun.iiim.*;

class PreeditWindow extends IIIMWindow implements IIIMPreeditListener {
    String style;
    
    PreeditPane pane;
    
    int columWidth, columHeight;
    
    // Below-spot offset value
    int offset = 20;
    
    // Default, no arg constructor
    public PreeditWindow() {
        style = Manager.getProperty("iiimf.preedit.style");
        if(style == null) style = "ROOTWINDOW";
    }
    
    void init() {
        window = new Dialog(new Frame(""));
        ((Dialog)window).setResizable(true);
        
        ((Dialog)window).setTitle("Preedit Window");
        
	Font font = new Font("Monospaced", Font.PLAIN, 12);
	
        FontMetrics fm = window.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        int fontWidth = fm.getMaxAdvance();
        int fontAscent = fm.getAscent();
        columWidth = fontWidth ;
        columHeight = fontHeight + 2;
        	
        window.setFont(font);

        pane = new PreeditPane();
        pane.setFont(font);
        window.add(pane);

	window.pack();                
    }
    
    // IIIMPreeditListener method
    public void preeditStart(IIIMPreeditEvent e) {
    }
    public void preeditDone(IIIMPreeditEvent e) {
    }
    public void preeditDraw(IIIMPreeditEvent e) {
    }

    public void dispatchEvent(IIIMPreeditEvent e) {
        if(pane == null) init();
        
        pane.handleEvent(e);
        
        Insets inset = window.getInsets();
        
        int width = inset.left + inset.right + pane.width();
        int height = inset.top + inset.bottom + pane.height();
        
        window.setSize(width, height);
        calculatePosition();

        window.show();
    }
    
    public void setStyle(String style) {
        this.style = style;
    }
    
    public String getStyle() {
        return style;
    }
    
    void calculatePosition() {
        Component component = getClientComponent();
        
        Component frame = component;
        while(!(frame instanceof Frame)) frame = component.getParent();        

        if(style.equals("BELOWSPOT") && 
            component instanceof InputMethodRequests) {
                Rectangle rect = 
                    ((InputMethodRequests)component).getTextLocation(TextHitInfo.leading(0));
                Point point = new Point();
                point.x = rect.x;
                point.y = rect.y + (int)rect.getHeight() + offset;
                
                window.setLocation(point);
        } else {
            // for ROOTWINDOW style and client not InputMethodRequests
            // Place the window on the left-corner of client component
            Point point = frame.getLocation();
            Dimension size = frame.getSize();     
        
            double x = point.getX();
            double y = point.getY() + size.getHeight();
            window.setLocation((int)x, (int)y);
        }
        
        // If window is out of screen, adjust it
        Point location = window.getLocation();
        double xl = location.getX();
        double yl = location.getY();
        Dimension dm = window.getSize();
        if((xl + dm.getWidth()) > screenWidth) 
            xl = screenWidth - dm.getWidth();
        if((yl + dm.getHeight()) > screenHeight) 
            yl = screenHeight - dm.getHeight();
        window.setLocation((int)xl, (int)yl);
    }
}
