/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package sun.awt.im.iiimp;

interface IIIMProtocol {
    // Version of this protocol spec.
    final static int VERSION				= 1;
    
    // Packet size
    final static int FOURBYTES_PACKET 			= 0;
    final static int EIGHTBYTES_PACKET 			= 1;

    // Protocol values
    final static int IM_NO_PROTOCOL 			= 0;
    final static int IM_CONNECT 			= 1;
    final static int IM_CONNECT_REPLY			= 2;
    final static int IM_DISCONNECT			= 3;
    final static int IM_DISCONNECT_REPLY		= 4;
    final static int IM_REGISTER_TRIGGER_KEYS		= 5;
    final static int IM_TRIGGER_NOTIFY  		= 6;
    final static int IM_TRIGGER_NOTIFY_REPLY		= 7;
    final static int IM_SETIMVALUES			= 8;
    final static int IM_SETIMVALUES_REPLY		= 9;
    final static int IM_GETIMVALUES			= 10;
    final static int IM_GETIMVALUES_REPLY		= 11;
    final static int IM_FORWARD_EVENT			= 12;
    final static int IM_FORWARD_EVENT_REPLY		= 13;
    final static int IM_COMMIT_STRING			= 14;
    final static int IM_FORWARD_EVENT_WITH_OPERATIONS	= 15;
    final static int IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY		= 16;
    final static int IM_CREATEIC			= 20;
    final static int IM_CREATEIC_REPLY  		= 21;
    final static int IM_DESTROYIC			= 22;
    final static int IM_DESTROYIC_REPLY 		= 23;
    final static int IM_SETICVALUES			= 24;
    final static int IM_SETICVALUES_REPLY		= 25;
    final static int IM_GETICVALUES			= 26;
    final static int IM_GETICVALUES_REPLY		= 27;
    final static int IM_SETICFOCUS			= 28;
    final static int IM_SETICFOCUS_REPLY		= 29;
    final static int IM_UNSETICFOCUS			= 30;
    final static int IM_UNSETICFOCUS_REPLY		= 31;
    final static int IM_RESETIC				= 32;
    final static int IM_RESETIC_REPLY			= 33;
    final static int IM_PREEDIT_START			= 40;
    final static int IM_PREEDIT_START_REPLY		= 41;
    final static int IM_PREEDIT_DRAW			= 42;
    final static int IM_PREEDIT_DRAW_REPLY		= 43;
    final static int IM_PREEDIT_DONE			= 46;
    final static int IM_PREEDIT_DONE_REPLY		= 47;
    final static int IM_STATUS_START			= 50;
    final static int IM_STATUS_START_REPLY		= 51;
    final static int IM_STATUS_DRAW			= 52;
    final static int IM_STATUS_DRAW_REPLY		= 53;
    final static int IM_STATUS_DONE			= 54;
    final static int IM_STATUS_DONE_REPLY		= 55;
    final static int IM_LOOKUP_CHOICE_START		= 70;
    final static int IM_LOOKUP_CHOICE_START_REPLY	= 71;
    final static int IM_LOOKUP_CHOICE_DRAW		= 72;
    final static int IM_LOOKUP_CHOICE_DRAW_REPLY	= 73;
    final static int IM_LOOKUP_CHOICE_DONE		= 74;
    final static int IM_LOOKUP_CHOICE_DONE_REPLY	= 75;
    final static int IM_LOOKUP_CHOICE_PROCESS		= 76;
    final static int IM_LOOKUP_CHOICE_PROCESS_REPLY	= 77;

    final static int IM_OPEN_NS 			= 80;
    final static int IM_OPEN_NS_REPLY			= 81;

    final static int IM_AUX_START			= 90;
    final static int IM_AUX_START_REPLY 		= 91;
    final static int IM_AUX_DRAW			= 92;
    final static int IM_AUX_DRAW_REPLY  		= 93;
    final static int IM_AUX_DONE			= 94;
    final static int IM_AUX_DONE_REPLY  		= 95;
    final static int IM_AUX_SETVALUES			= 96;
    final static int IM_AUX_SETVALUES_REPLY  		= 97;

    // Encoding values
    final static int BIGENDIAN				= 0x42;
    final static int LITTLEENDIAN			= 0x6c;

    final static int LOOKUP_MAX_NUMBER			= 1;
    final static int LOOKUP_STYLE			= 2;
    final static int QUERY_LOOKUP_STYLE 		= 3;
    final static int INPUT_LANGUAGE			= 4;
    final static int PRIMARY_LANGUAGE			= 5;

    // CONTENTS type
    final static int STRING				= 0;
    final static int TEXT				= 1;
    final static int KEYEVENT				= 2;

    // ATTRIBID
    final static int INPUTMETHOD_LIST			= 0x1001;
    final static int OBJECT_DESCRIPTER_LIST		= 0x1010;
    final static int CLIENT_DESCRIPTER			= 0x1011;
    final static int CCDEF				= 0x1030;
    final static int GUI_OBJECT				= 0x1031;
    final static int LWE_OBJECT				= 0x1032;

    // IC ATTRIBID
    final static int IC_INPUT_LANGUAGE			= 1;
    final static int IC_CHARACTER_SUBSETS		= 2;
    final static int IC_INPUT_METHOD			= 3;

    // Object Category
    final static int NOID				= -1;
    final static int GUI_CATEGORY			= 0;
    final static int LWE_CATEGORY			= 1;
    final static int SYNTAX_RULE_CATEGORY		= 2;
    final static int MANAGE_RULE_CATEGORY		= 3;

    // Feedback ID
    final static int DECORATION_FEEDBACK		= 0;
    final static int FOREGROUND_RGB_FEEDBACK		= 1;
    final static int BACKGROUND_RGB_FEEDBACK		= 2;
    final static int UNDERLINE_RGB_FEEDBACK		= 3;

    // Annotation ID
    final static int INPUT_STRING			= 0;
    final static int READING				= 1;
    final static int PART_OF_SPEECH			= 2;
    final static int CLAUSE				= 3;
}

