/*
 * convtable.h: Romaji kana converter table text c header
 * (This file is converted from converter.txt with converter.pl)
 *
 * Copyright (C) 2001-2002 Yukihiro Nakai <nakai@gnome.gr.jp>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _CONVTABLE_H
#define _CONVTABLE_H

typedef struct _romapair {
  char* roma;
  char* kana;
} romapair;

romapair kanatable[] = {
  { "ka", "" },
  { "ki", "" },
  { "ku", "" },
  { "ke", "" },
  { "ko", "" },

  { "sa", "" },
  { "si", "" },
  { "su", "" },
  { "se", "" },
  { "so", "" },

  { "ta", "" },
  { "ti", "" },
  { "tu", "" },
  { "te", "" },
  { "to", "" },

  { "na", "" },
  { "ni", "" },
  { "nu", "" },
  { "ne", "" },
  { "no", "" },

  { "ha", "" },
  { "hi", "" },
  { "hu", "" },
  { "he", "" },
  { "ho", "" },

  { "ma", "" },
  { "mi", "" },
  { "mu", "" },
  { "me", "" },
  { "mo", "" },

  { "ya", "" },
  { "yi", "" },
  { "yu", "" },
  { "ye", "" },
  { "yo", "" },

  { "ra", "" },
  { "ri", "" },
  { "ru", "" },
  { "re", "" },
  { "ro", "" },

  { "wa", "" },
  { "wi", "" },
  { "wu", "" },
  { "we", "" },
  { "wo", "" },

  { "ga", "" },
  { "gi", "" },
  { "gu", "" },
  { "ge", "" },
  { "go", "" },

  { "za", "" },
  { "zi", "" },
  { "zu", "" },
  { "ze", "" },
  { "zo", "" },

  { "da", "" },
  { "di", "" },
  { "du", "" },
  { "de", "" },
  { "do", "" },

  { "ba", "" },
  { "bi", "" },
  { "bu", "" },
  { "be", "" },
  { "bo", "" },

  { "va", "" },
  { "vi", "" },
  { "vu", "" },
  { "ve", "" },
  { "vo", "" },

  { "pa", "" },
  { "pi", "" },
  { "pu", "" },
  { "pe", "" },
  { "po", "" },

  { "fa", "դ" },
  { "fi", "դ" },
  { "fu", "" },
  { "fe", "դ" },
  { "fo", "դ" },

  { "ja", "" },
  { "ji", "" },
  { "ju", "" },
  { "je", "" },
  { "jo", "" },

  { "kya", "" },
  { "kyi", "" },
  { "kyu", "" },
  { "kye", "" },
  { "kyo", "" },

  { "gya", "" },
  { "gyi", "" },
  { "gyu", "" },
  { "gye", "" },
  { "gyo", "" },

  { "sya", "" },
  { "syi", "" },
  { "syu", "" },
  { "sye", "" },
  { "syo", "" },

  { "zya", "" },
  { "zyi", "" },
  { "zyu", "" },
  { "zye", "" },
  { "zyo", "" },

  { "tya", "" },
  { "tyi", "" },
  { "tyu", "" },
  { "tye", "" },
  { "tyo", "" },

  { "dya", "¤" },
  { "dyi", "¤" },
  { "dyu", "¤" },
  { "dye", "¤" },
  { "dyo", "¤" },

  { "nya", "ˤ" },
  { "nyi", "ˤ" },
  { "nyu", "ˤ" },
  { "nye", "ˤ" },
  { "nyo", "ˤ" },
  { "hya", "Ҥ" },
  { "hyi", "Ҥ" },
  { "hyu", "Ҥ" },
  { "hye", "Ҥ" },
  { "hyo", "Ҥ" },

  { "bya", "Ӥ" },
  { "byi", "Ӥ" },
  { "byu", "Ӥ" },
  { "bye", "Ӥ" },
  { "byo", "Ӥ" },

  { "pya", "Ԥ" },
  { "pyi", "Ԥ" },
  { "pyu", "Ԥ" },
  { "pye", "Ԥ" },
  { "pyo", "Ԥ" },

  { "mya", "ߤ" },
  { "myi", "ߤ" },
  { "myu", "ߤ" },
  { "mye", "ߤ" },
  { "myo", "ߤ" },

  { "rya", "" },
  { "ryi", "ꤣ" },
  { "ryu", "" },
  { "rye", "ꤧ" },
  { "ryo", "" },

  { "tsa", "Ĥ" },
  { "tsi", "Ĥ" },
  { "tsu", "" },
  { "tse", "Ĥ" },
  { "tso", "Ĥ" },

  { "sha", "" },
  { "shi", "" },
  { "shu", "" },
  { "she", "" },
  { "sho", "" },

  { "cha", "" },
  { "chi", "" },
  { "chu", "" },
  { "che", "" },
  { "cho", "" },

  { "jya", "" },
  { "jyi", "" },
  { "jyu", "" },
  { "jye", "" },
  { "jyo", "" },

  { "tha", "Ƥ" },
  { "thi", "Ƥ" },
  { "thu", "Ƥ" },
  { "the", "Ƥ" },
  { "tho", "Ƥ" },

  { "dha", "Ǥ" },
  { "dhi", "Ǥ" },
  { "dhu", "Ǥ" },
  { "dhe", "Ǥ" },
  { "dho", "Ǥ" },

  { "la", "" },
  { "le", "" },
  { "li", "" },
  { "lo", "" },
  { "ltu", "" },
  { "ltsu", "" },
  { "lu", "" },
  { "lya", "" },
  { "lye", "" },
  { "lyi", "" },
  { "lyo", "" },
  { "lyu", "" },

  { "xa", "" },
  { "xe", "" },
  { "xi", "" },
  { "xo", "" },
  { "xtu", "" },
  { "xtsu", "" },
  { "xu", "" },
  { "xya", "" },
  { "xye", "" },
  { "xyi", "" },
  { "xyo", "" },
  { "xyu", "" },

  { "nn", "" },

  { "nk", "k" },
  { "ns", "s" },
  { "nt", "t" },
  { "nh", "h" },
  { "nm", "m" },
  { "nr", "r" },
  { "nw", "w" },
  { "ng", "g" },
  { "nz", "z" },
  { "nd", "d" },
  { "nb", "b" },

  { "kk", "k" },
  { "ss", "s" },
  { "tt", "t" },
  { "hh", "h" },
  { "mm", "m" },
  { "yy", "y" },
  { "rr", "r" },
  { "ww", "w" },
  { "gg", "g" },
  { "zz", "z" },
  { "dd", "d" },
  { "bb", "b" },
  { "pp", "p" },
  { "cc", "c" },
  { "ff", "f" },
  { "jj", "j" },
  { "qq", "q" },
  { "vv", "v" },
  { "tch", "ch" },

  { "a", "" },
  { "i", "" },
  { "u", "" },
  { "e", "" },
  { "o", "" },

  { "-", "" },
  { "@", "" },
};

#endif /* _CONVTABLE_H */
