#ifndef _IBML_H_
#define _IBML_H_

/*
IBML: Input Bean Markup Language

It's designed mainly for the configure for language engines and auxiliary window.

the format of ibml file as follow:

<imconfig scope="cle">
<im scope="engines">
<imbean id="palette_aux">
    <property
        name="object"
        value="/usr/lib/im/locale/zh_CN/PaletteAux"/>
    <property
        name="args"
        value="-locale zh_CN.gb18030"/>
</imbean>
</im>
</imconfig>

*/

#define IBML_ELEMENT_ROOT             "imconfig"
#define IBML_ELEMENT_SCOPE            "scope"
#define IBML_ELEMENT_CATAGORY         "im"
#define IBML_ELEMENT_IMBEAN           "imbean"
#define IBML_ELEMENT_IMBEAN_ID        "id"
#define IBML_ELEMENT_PROPERTY         "property"
#define IBML_ELEMENT_PROPERTY_NAME    "name"
#define IBML_ELEMENT_PROPERTY_VALUE   "value"
#define IBML_ELEMENT_PROPERTY_OPTIONS "options"
#define IBML_ELEMENT_PROPERTY_TYPE    "type"

#define IBML_OK            0
#define IBML_ERROR         -1

#ifdef True
#undef True
#endif
#define True 1

#ifdef False
#undef False
#endif
#define False 0

typedef struct _IbmlProperty {
	char *name;
	char *type;
	char *value;
	char *options;
	char *scope;
} IbmlProperty, *IbmlPropertyPtr;

typedef struct _IbmlElement {
	char *id;
	char *scope;
	char *class;

	int num_properties;
	IbmlPropertyPtr *properties;
} IbmlElement, *IbmlElementPtr;

typedef struct _IbmlCatagory {
	char *scope;

	int num_elements;
	IbmlElementPtr *elements;
} IbmlCatagory, *IbmlCatagoryPtr;

typedef struct _IbmlData {
	char *scope;
	int num_catagories;
	IbmlCatagoryPtr *catagories;
} IbmlData;

#endif /* _IBML_H_ */
