#include <stdio.h>
#include <stdlib.h>

#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gtkiiimwin.h"

extern GdkFilterReturn xaux_ext_event_handler(GdkXEvent * gdk_xevent,
                                              GdkEvent * event,
                                              gpointer user_data);

void * composite_aux;
static GtkWidget* mainwin = NULL;

static void
pc_aux_option_change(TIIimPCWin vpc, int op)
{
    TPCStyleOption* pcstyle = (TPCStyleOption*)op;
    composite_aux_send_option_change(pcstyle);
}
 
static void
pc_aux_candidate_selection(TIIimPCWin vpc, int idx)
{
    composite_aux_send_candidate_selection(idx);
}

static void
pc_aux_candidate_page_request(TIIimPCWin vpc, int pgop)
{
    composite_aux_send_candidate_page(pgop);
}

static void
pc_aux_move_notify(TIIimPCWin vpc, int op)
{
    int cursor_x, cursor_y, cursor_w, cursor_h;
    getPCCursorPosition(vpc, &cursor_x, &cursor_y, &cursor_w, &cursor_h);
    composite_aux_send_move(cursor_x, cursor_y, cursor_w, cursor_h);
}

static const char* example_preedit = "<span color=\"darkblue\">在经过了yi duan shi jian de nu li zhi hou</span>";
static int example_caret  = 37;
static int example_candi_start = 4;
static const char* example_candidates[] = {
    "<span color=\"darkgreen\">1.一段时间的努力之后</span>",
    "<span color=\"darkblue\">2.一段时间</span>",
    "3.一段",
    "4.一端",
    "5.异端",
    "6.臆断"
};

int main(int argc, char **argv)
{
    int style_id = 0;
    gtk_init (&argc, &argv);

    add_pixmap_directory (LE_PIXMAPS_DIR);
    add_pixmap_directory ("./pixmaps");

    mainwin = gtk_window_new(GTK_WINDOW_POPUP);
    gtk_widget_realize(mainwin);

    if (argc > 1)
        style_id = atoi(argv[1]);
    composite_aux = createStockPreeditCandidatesWindows(style_id);

    
    registerStyleChangeCallback(composite_aux, pc_aux_option_change);
    registerSelectionCallback(composite_aux, pc_aux_candidate_selection);
    registerPageCallback(composite_aux, pc_aux_candidate_page_request);
    registerMoveCallback(composite_aux, pc_aux_move_notify);

    if (argc > 1) {
        updatePreedit(composite_aux, example_preedit, example_caret, example_candi_start, 0, 0);
        updateCandidates(composite_aux, 6, example_candidates, "Sun拼音", 0, 0, 100, NULL, NULL);
        movePreedit(composite_aux, 300, 280, 12, 22);
        showCandidates(composite_aux);
        showPreedit(composite_aux);
    }


    gdk_window_add_filter(mainwin->window, xaux_ext_event_handler, 0);

    if (xaux_ext_register_classes(mainwin->window) == False) return (False);

    gtk_main();
}

