#include <stdio.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define MAX_LINE_LEN 		256
#define FULLWIDE_CHAR_NUM 	94
#define PUNCT_CHAR_NUM 		18

char *FullWideCharListByLang_CN[FULLWIDE_CHAR_NUM] = {
    "！",
    "＂",
    "＃",
    "＄",
    "％",
    "＆",
    "＇",
    "（",
    "）",
    "＊",
    "＋",
    "，",
    "－",
    "．",
    "／",
    "０",
    "１",
    "２",
    "３",
    "４",
    "５",
    "６",
    "７",
    "８",
    "９",
    "：",
    "；",
    "＜",
    "＝",
    "＞",
    "？",
    "＠",
    "Ａ",
    "Ｂ",
    "Ｃ",
    "Ｄ",
    "Ｅ",
    "Ｆ",
    "Ｇ",
    "Ｈ",
    "Ｉ",
    "Ｊ",
    "Ｋ",
    "Ｌ",
    "Ｍ",
    "Ｎ",
    "Ｏ",
    "Ｐ",
    "Ｑ",
    "Ｒ",
    "Ｓ",
    "Ｔ",
    "Ｕ",
    "Ｖ",
    "Ｗ",
    "Ｘ",
    "Ｙ",
    "Ｚ",
    "［",
    "＼",
    "］",
    "＾",
    "＿",
    "｀",
    "ａ",
    "ｂ",
    "ｃ",
    "ｄ",
    "ｅ",
    "ｆ",
    "ｇ",
    "ｈ",
    "ｉ",
    "ｊ",
    "ｋ",
    "ｌ",
    "ｍ",
    "ｎ",
    "ｏ",
    "ｐ",
    "ｑ",
    "ｒ",
    "ｓ",
    "ｔ",
    "ｕ",
    "ｖ",
    "ｗ",
    "ｘ",
    "ｙ",
    "ｚ",
    "｛",
    "｜",
    "｝",
    "￣",
};

char *FullWideCharListByLang_TW[FULLWIDE_CHAR_NUM] = {
    "！",
    "〃",
    "＃",
    "＄",
    "％",
    "＆",
    "′",
    "（",
    "）",
    "﹡",
    "＋",
    "，",
    "－",
    "．",
    "／",
    "０",
    "１",
    "２",
    "３",
    "４",
    "５",
    "６",
    "７",
    "８",
    "９",
    "：",
    "；",
    "〈",
    "＝",
    "〉",
    "？",
    "＠",
    "Ａ",
    "Ｂ",
    "Ｃ",
    "Ｄ",
    "Ｅ",
    "Ｆ",
    "Ｇ",
    "Ｈ",
    "Ｉ",
    "Ｊ",
    "Ｋ",
    "Ｌ",
    "Ｍ",
    "Ｎ",
    "Ｏ",
    "Ｐ",
    "Ｑ",
    "Ｒ",
    "Ｓ",
    "Ｔ",
    "Ｕ",
    "Ｖ",
    "Ｗ",
    "Ｘ",
    "Ｙ",
    "Ｚ",
    "【",
    "＼",
    "】",
    "︿",
    "＿",
    "‵",
    "ａ",
    "ｂ",
    "ｃ",
    "ｄ",
    "ｅ",
    "ｆ",
    "ｇ",
    "ｈ",
    "ｉ",
    "ｊ",
    "ｋ",
    "ｌ",
    "ｍ",
    "ｎ",
    "ｏ",
    "ｐ",
    "ｑ",
    "ｒ",
    "ｓ",
    "ｔ",
    "ｕ",
    "ｖ",
    "ｗ",
    "ｘ",
    "ｙ",
    "ｚ",
    "｛",
    "｜",
    "｝",
    "∼",
};

char PunctChars[PUNCT_CHAR_NUM] = {
    '!', '"', '$', '&', '\'',
    '(', ')', ',', '.',
    ':', ';', '<', '>', '?',
    '@', '\\', '^', '_'
};

char *PunctCharListByLang_CN[PUNCT_CHAR_NUM] = {
    "！",
    "“",
    "￥",
    "─",
    "‘",
    "（",
    "）",
    "，",
    "。",
    "：",
    "；",
    "》",
    "《",
    "？",
    "＠",
    "、",
    "…",
    "＿＿",
};

char *PunctCharListByLang_TW[PUNCT_CHAR_NUM] = {
    "！",
    "“",
    "NT$",
    "─",
    "‘",
    "（",
    "）",
    "，",
    "。",
    "：",
    "；",
    "《",
    "》",
    "？",
    "＠",
    "、",
    "…",
    "＿＿",
};

char *PunctCharListByLang_HK[PUNCT_CHAR_NUM] = {
    "！",
    "“",
    "HK$",
    "─",
    "‘",
    "（",
    "）",
    "，",
    "。",
    "：",
    "；",
    "《",
    "》",
    "？",
    "＠",
    "、",
    "…",
    "＿＿",
};

char *get_qj_str(char ch)
{
    int ch_pos;

    ch_pos = ch - 0x21;

    if (ch_pos < 0 || ch_pos >= FULLWIDE_CHAR_NUM)
	return (NULL);

#ifdef LE_ZH_CN
    return (FullWideCharListByLang_CN[ch_pos]);
#else
    return (FullWideCharListByLang_TW[ch_pos]);
#endif
}

char *get_punct_str(char ch)
{
    int i, ch_pos;
    char *str;

    ch_pos = -1;
    for (i = 0; i < PUNCT_CHAR_NUM; i++) {
	if (ch == PunctChars[i]) {
	    ch_pos = i;
	    break;
	}
    }
    if (ch_pos == -1)
	return (NULL);

#ifdef LE_ZH_CN
    return (PunctCharListByLang_CN[ch_pos]);
#else
#ifdef LE_ZH_TW
    return (PunctCharListByLang_TW[ch_pos]);
#else
    return (PunctCharListByLang_HK[ch_pos]);
#endif
#endif
}
