/*
  commit.c
*/

#include <stdlib.h>
#include "iiimcfint.h"

IIIMF_status
iiimcf_commit_string(
    IIIMCF_context_rec *pc,
    IIIMP_message *pmes
)
{
    IIIMF_status st;
    IIIMP_contents *pcon = pmes->v.commit_string.contents;

    ASSERT(pmes->opcode == IM_COMMIT_STRING);

    if (IIIMCF_IS_STATE_CHANGED(pc, IIIMCF_STATE_COMMIT_REQUIRED)) {
	/* In the same session, the server sends IM_COMMIT_STRING more than
	   once.  We should simply concatenate the commit string.  */
	st = iiimcf_append_contents_to_text(&pc->committed_text, pcon);
	if (st != IIIMF_STATUS_SUCCESS) return st;
	IIIMCF_SET_STATE(pc, IIIMCF_CONTEXT_COMMITTED_TEXT_ENABLED);
    } else {
	/* First commit since the last session is initiated.  */
	st = iiimcf_convert_iiimp_contents_to_text(pcon, &pc->committed_text);
	if (st != IIIMF_STATUS_SUCCESS) return st;
	IIIMCF_SET_STATE(pc, IIIMCF_CONTEXT_COMMITTED_TEXT_ENABLED);
	IIIMCF_SET_STATE_CHANGE(pc, IIIMCF_STATE_COMMIT_REQUIRED);
	st = iiimcf_store_simple_event(pc, IIIMCF_EVENT_TYPE_UI_COMMIT);
    }

    return st;
}

IIIMF_status
iiimcf_get_committed_text(
    IIIMCF_context context,
    IIIMCF_text *ptext
)
{
    IIIMCF_context_rec *pc = (IIIMCF_context_rec*) context;

    if (IIIMCF_IS_IC_INVALID(pc)) return IIIMF_STATUS_IC_INVALID;
    if ((!IIIMCF_IS_ENABLED(pc, IIIMCF_CONTEXT_COMMITTED_TEXT_ENABLED))
	|| (!IIIMCF_IS_VALID_TEXT(&pc->committed_text)))
	return IIIMF_STATUS_NO_COMMITTED_TEXT;

    *ptext = &pc->committed_text;

    return IIIMF_STATUS_SUCCESS;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
