#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include <iiimp-data.h>

#include "iiimp-dataP.h"


/* ARGSUSED0 */
void
iiimp_invalid_message_delete(IIIMP_data_s * data_s, IIIMP_message * m)
{
    return;
}


/* ARGSUSED1 */
uchar_t *
iiimp_invalid_message_pack(
    IIIMP_data_s *	data_s,
    IIIMP_message *	opcode,
    size_t *		buf_size)
{
    data_s->status = IIIMP_DATA_INVALID;
    return NULL;
}


/* ARGSUSED1 */
IIIMP_message *
iiimp_invalid_message_unpack(
    IIIMP_data_s *	data_s,
    IIIMP_card7		opcode,
    size_t *		nbyte,
    const uchar_t **	ptr)
{
    data_s->status = IIIMP_DATA_INVALID;
    return NULL;
}


void
iiimp_invalid_message_print(
    IIIMP_data_s *	data_s,
    IIIMP_message *	m)
{
    (void)fprintf(data_s->print_fp, "unknown message packet ");
    if (NULL == m) {
	(void)fprintf(data_s->print_fp, "(NULL)\n");
    } else {
	(void)fprintf(data_s->print_fp, "(%d)\n", m->opcode);
    }
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
