#include <stdlib.h>
#include <string.h>
#if defined(lint) && defined(HAVE_NOTE_H)
#include <note.h>
#endif /* lint && HAVE_NOTE_H */

#include <iiimp.h>

#include "input-method.h"
#include "role-data-server.h"


#define SERVICE_DEFAULT	"9010"


IIIMF_status
iiimf_role_data_server_new(
    const char *		service,
    IIIMF_role_data_server **	server_ret)
{
    IIIMF_role_data_server *	server;

    server = (IIIMF_role_data_server *)malloc(sizeof (IIIMF_role_data_server));
    if (NULL == server) return IIIMF_STATUS_MALLOC;

    server->service = ((NULL == service) ?
		       strdup(SERVICE_DEFAULT) : strdup(service));
    if (NULL == server->service) {
	free(server);
	return IIIMF_STATUS_MALLOC;
    }

    *server_ret = server;

    return IIIMF_STATUS_SUCCESS;
}


void
iiimf_role_data_server_delete(IIIMF_role_data_server * server)
{
    free(server->service);
    free(server);
}


const char *
iiimf_role_data_server_service(IIIMF_im * im)
{
    return im->role_data.server->service;
}


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
