#include "simple-controller.h"

SimpleController::SimpleController()
{
	set_title("Simple Controller");
	set_default_size(250, 0);

	entry = new Gtk::Entry;
	add(*entry);
	
	// Get the default client
	client = GConf::Client::get_default();
	
	// Tell GConf::Client that we're interested in the given directory. We use PRELOAD_NONE
	// to avoid loading all config keys on startup.
	client->add_dir("/extra/test/directory", GConf::Client::PRELOAD_NONE);

	entry->sig_activate().connect(slot(this, &SimpleController::on_entry_activated));

	// If the key isn't writable, then set entry insensitive.
	entry->set_sensitive(client->key_is_writable("/extra/test/directory/key"));
	entry->show();
}

SimpleController::~SimpleController()
{
}

void
SimpleController::on_entry_activated()
{
	String s = entry->get_chars(0, -1);
	client->set_string("/extra/test/directory/key", s);
}

int main (int argc, char *argv[])
{
	using namespace Main;

	init(&argc, &argv);

	SimpleController window;
	window.sig_destroy().connect(slot(&Inti::Main::quit));
	window.show();

	run();
	return 0;
}

