/*  Inti-GConf: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  client_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GCONF_CLIENT_CLASS_H
#define INTI_GCONF_CLIENT_CLASS_H

#include <inti/glib/private/object_p.h>

namespace Inti {

namespace GConf {

class ClientClass
{
public:
	static void init(GConfClientClass *g_class);

	static GType get_type();

	static void* create();

	static void value_changed_proxy(GConfClient* client, const gchar* key, GConfValue* value);

	static void unreturned_error_proxy(GConfClient* client, GError* error);

	static void error_proxy(GConfClient* client, GError* error);
};

} // namespace GConf

} // namespace Inti

#endif // INTI_GCONF_CLIENT_CLASS_H

