#-----------------------------------------------------------------------#
#        IPAcco - Cisco IP accounting collector and visualizer          #
#                          Version 0.2
#             Copyright (c) 2004-2005 Dmitriy Stepanenko
#-----------------------------------------------------------------------#
# This source file is subject the license, that is bundled with this    #
# package in the file LICENSE.                                          #
# If you did not receive a copy of the Mudropolk license, please send a #
# note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          #
#-----------------------------------------------------------------------#
# Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> #
#-----------------------------------------------------------------------#
# $Id: CreateDB.sql,v 1.5 2005/04/14 11:49:43 mpolk Exp $               #
# Database creation script.                                             #
#-----------------------------------------------------------------------#

CREATE DATABASE ipacco;
USE ipacco;


CREATE TABLE `AddrConditions` (
  `FilterID` int(10) unsigned NOT NULL default '0',
  `SeqN` int(10) unsigned NOT NULL default '0',
  `Level` smallint(5) unsigned NOT NULL default '0',
  `AddrType` enum('s','d') NOT NULL default 's',
  `CondType` enum('e','n') NOT NULL default 'e',
  `Addr1` tinyint(3) unsigned NOT NULL default '0',
  `Addr2` tinyint(3) unsigned NOT NULL default '0',
  `Addr3` tinyint(3) unsigned NOT NULL default '0',
  `Addr4` tinyint(3) unsigned NOT NULL default '0',
  `MaskLen` tinyint(3) unsigned NOT NULL default '0',
  `ConnectiveType` enum('&','|') NOT NULL default '&',
  PRIMARY KEY  (`FilterID`,`SeqN`)
) TYPE=InnoDB COMMENT='IP-address query filter details'; 


CREATE TABLE `AddrFilters` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `Name` varchar(32) NOT NULL default '',
  `Description` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `ByName` (`Name`)
) TYPE=InnoDB COMMENT='IP-address query filter headers'; 


CREATE TABLE `DayData` (
  `ReadoutID` int(10) unsigned NOT NULL default '0',
  `Src1` tinyint(3) unsigned NOT NULL default '0',
  `Src2` tinyint(3) unsigned NOT NULL default '0',
  `Src3` tinyint(3) unsigned NOT NULL default '0',
  `Src4` tinyint(3) unsigned NOT NULL default '0',
  `Dst1` tinyint(3) unsigned NOT NULL default '0',
  `Dst2` tinyint(3) unsigned NOT NULL default '0',
  `Dst3` tinyint(3) unsigned NOT NULL default '0',
  `Dst4` tinyint(3) unsigned NOT NULL default '0',
  `Bytes` int(10) unsigned NOT NULL default '0',
  `Packets` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ReadoutID`,`Src1`,`Src2`,`Src3`,`Src4`,`Dst1`,`Dst2`,`Dst3`,`Dst4`),
  UNIQUE KEY `ByDstSrcTime` (`Dst1`,`Dst2`,`Dst3`,`Dst4`,`Src1`,`Src2`,`Src3`,`Src4`,`ReadoutID`),
  UNIQUE KEY `BySrcDstTime` (`Src1`,`Src2`,`Src3`,`Src4`,`Dst1`,`Dst2`,`Dst3`,`Dst4`,`ReadoutID`),
  UNIQUE KEY `ByTimeDstSrc` (`ReadoutID`,`Dst1`,`Dst2`,`Dst3`,`Dst4`,`Src1`,`Src2`,`Src3`,`Src4`)
) TYPE=InnoDB COMMENT='Contains raw counters dumped from a router'; 


CREATE TABLE `DayReadouts` (
  `ID` int(11) unsigned NOT NULL auto_increment,
  `Time` datetime NOT NULL default '0000-00-00 00:00:00',
  `Age` smallint(6) default '0',
  `Packed` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `ByTime` (`Time`)
) TYPE=InnoDB COMMENT='Contains time marks for the day data'; 


CREATE TABLE `MonthData` (
  `ReadoutID` int(10) unsigned NOT NULL default '0',
  `Src1` tinyint(3) unsigned NOT NULL default '0',
  `Src2` tinyint(3) unsigned NOT NULL default '0',
  `Src3` tinyint(3) unsigned NOT NULL default '0',
  `Src4` tinyint(3) unsigned NOT NULL default '0',
  `Dst1` tinyint(3) unsigned NOT NULL default '0',
  `Dst2` tinyint(3) unsigned NOT NULL default '0',
  `Dst3` tinyint(3) unsigned NOT NULL default '0',
  `Dst4` tinyint(3) unsigned NOT NULL default '0',
  `Bytes` int(10) unsigned NOT NULL default '0',
  `Packets` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ReadoutID`,`Src1`,`Src2`,`Src3`,`Src4`,`Dst1`,`Dst2`,`Dst3`,`Dst4`),
  UNIQUE KEY `ByDstSrcTime` (`Dst1`,`Dst2`,`Dst3`,`Dst4`,`Src1`,`Src2`,`Src3`,`Src4`,`ReadoutID`),
  UNIQUE KEY `BySrcDstTime` (`Src1`,`Src2`,`Src3`,`Src4`,`Dst1`,`Dst2`,`Dst3`,`Dst4`,`ReadoutID`),
  UNIQUE KEY `ByTimeDstSrc` (`ReadoutID`,`Dst1`,`Dst2`,`Dst3`,`Dst4`,`Src1`,`Src2`,`Src3`,`Src4`)
) TYPE=InnoDB COMMENT='Contains summarized counters for the last month(s)'; 


CREATE TABLE `MonthReadouts` (
  `ID` int(11) unsigned NOT NULL auto_increment,
  `Time` datetime NOT NULL default '0000-00-00 00:00:00',
  `Age` int(11) default '0',
  `Packed` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `ByTime` (`Time`)
) TYPE=InnoDB COMMENT='Contains time marks for the month data'; 


CREATE TABLE `Settings` (
  `Name` varchar(32) NOT NULL default '',
  `IntValue` int(11) default '0',
  `CharValue` varchar(255) default '',
  PRIMARY KEY  (`Name`)
) TYPE=InnoDB COMMENT='Contains various runtime parameters (integer and character) '; 

INSERT INTO Settings VALUES ('DayViewGrid',5,'min');
INSERT INTO Settings VALUES ('DayViewWindow',56,'hours');
INSERT INTO Settings VALUES ('WeekViewGrid',30,'min');
INSERT INTO Settings VALUES ('WeekViewWindow',2,'weeks');
INSERT INTO Settings VALUES ('MonthViewGrid',2,'hours');
INSERT INTO Settings VALUES ('MonthViewWindow',8,'weeks');
INSERT INTO Settings VALUES ('YearViewGrid',1,'days');
INSERT INTO Settings VALUES ('YearViewWindow',2,'years');
INSERT INTO Settings VALUES ('AddrGraphHeight',460,'pixels');
INSERT INTO Settings VALUES ('AddrGraphWidth',680,'pixels');
INSERT INTO Settings VALUES ('MaxAddrGraphWidth',30000,'pixels');
INSERT INTO Settings VALUES ('TimeGraphHeight',200,'pixels');
INSERT INTO Settings VALUES ('TimeGraphWidth',680,'pixels');


CREATE TABLE `WeekData` (
  `ReadoutID` int(10) unsigned NOT NULL default '0',
  `Src1` tinyint(3) unsigned NOT NULL default '0',
  `Src2` tinyint(3) unsigned NOT NULL default '0',
  `Src3` tinyint(3) unsigned NOT NULL default '0',
  `Src4` tinyint(3) unsigned NOT NULL default '0',
  `Dst1` tinyint(3) unsigned NOT NULL default '0',
  `Dst2` tinyint(3) unsigned NOT NULL default '0',
  `Dst3` tinyint(3) unsigned NOT NULL default '0',
  `Dst4` tinyint(3) unsigned NOT NULL default '0',
  `Bytes` int(10) unsigned NOT NULL default '0',
  `Packets` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ReadoutID`,`Src1`,`Src2`,`Src3`,`Src4`,`Dst1`,`Dst2`,`Dst3`,`Dst4`),
  UNIQUE KEY `ByDstSrcTime` (`Dst1`,`Dst2`,`Dst3`,`Dst4`,`Src1`,`Src2`,`Src3`,`Src4`,`ReadoutID`),
  UNIQUE KEY `BySrcDstTime` (`Src1`,`Src2`,`Src3`,`Src4`,`Dst1`,`Dst2`,`Dst3`,`Dst4`,`ReadoutID`),
  UNIQUE KEY `ByTimeDstSrc` (`ReadoutID`,`Dst1`,`Dst2`,`Dst3`,`Dst4`,`Src1`,`Src2`,`Src3`,`Src4`)
) TYPE=InnoDB COMMENT='Contains summarized counters for the last week(s)'; 


CREATE TABLE `WeekReadouts` (
  `ID` int(11) unsigned NOT NULL auto_increment,
  `Time` datetime NOT NULL default '0000-00-00 00:00:00',
  `Age` smallint(6) default '0',
  `Packed` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `ByTime` (`Time`)
) TYPE=InnoDB COMMENT='Contains time marks for the week data'; 


CREATE TABLE `YearData` (
  `ReadoutID` int(10) unsigned NOT NULL default '0',
  `Src1` tinyint(3) unsigned NOT NULL default '0',
  `Src2` tinyint(3) unsigned NOT NULL default '0',
  `Src3` tinyint(3) unsigned NOT NULL default '0',
  `Src4` tinyint(3) unsigned NOT NULL default '0',
  `Dst1` tinyint(3) unsigned NOT NULL default '0',
  `Dst2` tinyint(3) unsigned NOT NULL default '0',
  `Dst3` tinyint(3) unsigned NOT NULL default '0',
  `Dst4` tinyint(3) unsigned NOT NULL default '0',
  `Bytes` int(10) unsigned NOT NULL default '0',
  `Packets` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ReadoutID`,`Src1`,`Src2`,`Src3`,`Src4`,`Dst1`,`Dst2`,`Dst3`,`Dst4`),
  UNIQUE KEY `ByDstSrcTime` (`Dst1`,`Dst2`,`Dst3`,`Dst4`,`Src1`,`Src2`,`Src3`,`Src4`,`ReadoutID`),
  UNIQUE KEY `BySrcDstTime` (`Src1`,`Src2`,`Src3`,`Src4`,`Dst1`,`Dst2`,`Dst3`,`Dst4`,`ReadoutID`),
  UNIQUE KEY `ByTimeDstSrc` (`ReadoutID`,`Dst1`,`Dst2`,`Dst3`,`Dst4`,`Src1`,`Src2`,`Src3`,`Src4`)
) TYPE=InnoDB COMMENT='Contains summarized counters for the last year(s)'; 


CREATE TABLE `YearReadouts` (
  `ID` int(11) unsigned NOT NULL auto_increment,
  `Time` datetime NOT NULL default '0000-00-00 00:00:00',
  `Age` int(11) default '0',
  `Packed` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  UNIQUE KEY `ByTime` (`Time`)
) TYPE=InnoDB COMMENT='Contains time marks for the year data'; 


# Grants for ipacco-web@%
GRANT USAGE ON *.* TO 'ipacco-web'@'%' IDENTIFIED BY 'ipacco=web';
GRANT SELECT, REFERENCES ON `ipacco`.`DayReadouts` TO 'ipacco-web'@'%';
GRANT SELECT, REFERENCES ON `ipacco`.`DayData` TO 'ipacco-web'@'%';
GRANT SELECT, REFERENCES ON `ipacco`.`WeekReadouts` TO 'ipacco-web'@'%';
GRANT SELECT, REFERENCES ON `ipacco`.`WeekData` TO 'ipacco-web'@'%';
GRANT SELECT, REFERENCES ON `ipacco`.`MonthReadouts` TO 'ipacco-web'@'%';
GRANT SELECT, REFERENCES ON `ipacco`.`MonthData` TO 'ipacco-web'@'%';
GRANT SELECT, REFERENCES ON `ipacco`.`YearReadouts` TO 'ipacco-web'@'%';
GRANT SELECT, REFERENCES ON `ipacco`.`YearData` TO 'ipacco-web'@'%';
GRANT SELECT, INSERT, UPDATE, DELETE, REFERENCES ON `ipacco`.`Settings` TO 'ipacco-web'@'%';
GRANT SELECT, INSERT, UPDATE, DELETE, REFERENCES ON `ipacco`.`AddrConditions` TO 'ipacco-web'@'%';
GRANT SELECT, INSERT, UPDATE, DELETE, REFERENCES ON `ipacco`.`AddrFilters` TO 'ipacco-web'@'%';

# Grants for ipacco-pump@%
GRANT USAGE ON *.* TO 'ipacco-pump'@'%' IDENTIFIED BY 'ipacco=pump';
GRANT SELECT, REFERENCES ON `ipacco`.`Settings` TO 'ipacco-pump'@'%';
GRANT SELECT, INSERT, UPDATE, DELETE, REFERENCES ON `ipacco`.`DayReadouts` TO 'ipacco-pump'@'%';
GRANT SELECT, INSERT, UPDATE, DELETE, REFERENCES ON `ipacco`.`DayData` TO 'ipacco-pump'@'%';
GRANT SELECT, INSERT, UPDATE, DELETE, REFERENCES ON `ipacco`.`WeekReadouts` TO 'ipacco-pump'@'%';
GRANT SELECT, INSERT, UPDATE, DELETE, REFERENCES ON `ipacco`.`WeekData` TO 'ipacco-pump'@'%';
GRANT SELECT, INSERT, UPDATE, DELETE, REFERENCES ON `ipacco`.`MonthReadouts` TO 'ipacco-pump'@'%';
GRANT SELECT, INSERT, UPDATE, DELETE, REFERENCES ON `ipacco`.`MonthData` TO 'ipacco-pump'@'%';
GRANT SELECT, INSERT, UPDATE, DELETE, REFERENCES ON `ipacco`.`YearReadouts` TO 'ipacco-pump'@'%';
GRANT SELECT, INSERT, UPDATE, DELETE, REFERENCES ON `ipacco`.`YearData` TO 'ipacco-pump'@'%';
