<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: AddrCondition.php,v 1.1 2005/05/19 08:48:41 mpolk Exp $
| Class representing an IP-address selection condition.                 |
\----------------------------------------------------------------------*/

class AddrCondition {
    var $Level;
    var $AddrType;
    var $CondType;
    var $Addr;
    var $MaskLen;
    var $ConnectiveType;


    function AddrCondition($Level = 0, $AddrType = "s", $CondType = "eq",
                           $Addr1 = 0, $Addr2 = 0, $Addr3 = 0, $Addr4 = 0,
                           $MaskLen = 0, $ConnectiveType = "&")
    {
        $this->Level = $Level;

        if (strncasecmp($AddrType, "s", 1) == 0)
            $this->AddrType = "s";
        else
            $this->AddrType = "d";


        if (strncasecmp($CondType, "e", 1) == 0)
            $this->CondType = "eq";
        else
            $this->CondType = "ne";
        
        if (! is_numeric($Addr1) || $Addr1 < 0)
            $this->Addr[1] = 0;
        elseif ($Addr1 > 255)
            $this->Addr[1] = 255;
        else
            $this->Addr[1] = (int)$Addr1;
        if (! is_numeric($Addr2) || $Addr2 < 0)
            $this->Addr[2] = 0;
        elseif ($Addr2 > 255)
            $this->Addr[2] = 255;
        else
            $this->Addr[2] = (int)$Addr2;
        if (! is_numeric($Addr3) || $Addr3 < 0)
            $this->Addr[3] = 0;
        elseif ($Addr3 > 255)
            $this->Addr[3] = 255;
        else
            $this->Addr[3] = (int)$Addr3;
        if (! is_numeric($Addr4) || $Addr4 < 0)
            $this->Addr[4] = 0;
        elseif ($Addr4 > 255)
            $this->Addr[4] = 255;
        else
            $this->Addr[4] = (int)$Addr4;

        if (! is_numeric($MaskLen) || $MaskLen < 0)
            $this->MaskLen = 0;
        elseif ($MaskLen > 32)
            $this->MaskLen = 32;
        else
            $this->MaskLen = (int)$MaskLen;

        if ($ConnectiveType == "|")
            $this->ConnectiveType = "|";
        else
            $this->ConnectiveType = "&";
    }//ctor
    

    function IsEmpty()
    {
        return empty($this->MaskLen);
    }//IsEmpty

    
    function SQL() 
    {
        if ($this->IsEmpty())
            return "";

        if (substr($this->AddrType, 0, 1) == "s")
            $FieldPrefix = "Src";
        else
            $FieldPrefix = "Dst";
        if (substr($this->CondType, 0, 1) == "e") {
            $CompOp = "=";
            $InternalConnective = " AND ";
        } else {
            $CompOp = "<>";
            $InternalConnective = " OR ";
        }//if
            
        $SQL = "(";
        for ($i = 1; $i <= (int)($this->MaskLen / 8); $i++) {
            if ($SQL != "(")
                $SQL .= $InternalConnective;
            $SQL .= $FieldPrefix.$i." ".$CompOp." ".$this->Addr[$i];
        }//for
        
        $MaskFrac = $this->MaskLen % 8;
        if ($MaskFrac) {
            $MaskFrac = (0xFF00 >> $MaskFrac) & 0xFF;
            if ($SQL != "(")
                $SQL .= $InternalConnective;
            $SQL .= "(".$FieldPrefix.$i." & ".sprintf("0x%X", $MaskFrac).") ".
                    $CompOp." ".sprintf("0x%X", $this->Addr[$i] & $MaskFrac);
        }//if
        
        $SQL .= ")";
        
        return $SQL;
    }//SQL
    

    function ConnectiveTypeStr()
    {
        if ($this->ConnectiveType == "&")
            return "AND";
        else
            return "OR";
    }//ConnectiveTypeStr
    

    function SaveInDB($FilterID, $SeqN)
    {
        $Addr1 = $this->Addr[1];
        $Addr2 = $this->Addr[2];
        $Addr3 = $this->Addr[3];
        $Addr4 = $this->Addr[4];
        mysql_query("INSERT INTO AddrConditions 
                        (FilterID, SeqN, Level, 
                         AddrType, CondType,
                         Addr1, Addr2, Addr3, Addr4, 
                         MaskLen, ConnectiveType)
                     VALUES ($FilterID, $SeqN, $this->Level,
                         '".substr($this->AddrType, 0, 1)."', 
                         '".substr($this->CondType, 0, 1)."', 
                         $Addr1, $Addr2, $Addr3, $Addr4, 
                         $this->MaskLen, '$this->ConnectiveType')");
    }//SaveInDB


    function InitFromDBRow($Row)
    {
        $this->Level = $Row->Level;
        $this->AddrType = $Row->AddrType;
        $this->CondType = $Row->CondType;
        $this->Addr[1] = $Row->Addr1;
        $this->Addr[2] = $Row->Addr2;
        $this->Addr[3] = $Row->Addr3;
        $this->Addr[4] = $Row->Addr4;
        $this->MaskLen = $Row->MaskLen;
        $this->ConnectiveType = $Row->ConnectiveType;
    }//InitFromDBRow
}//AddrCondition

?>