<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2.0.1
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: AddrFilter.php,v 1.2 2005/11/07 09:25:09 mpolk Exp $
| Class representing an IP-address selection filter consisting          |
|  of one or more AddrCondtion elements.                                |
\----------------------------------------------------------------------*/

require_once("AddrCondition.php");

class AddrFilter {
    var $Name, $Description;
    var $NConds, $Conditions;

    // Initialize from the session vars
    function AddrFilter()
    {
        if (isset($_SESSION["AddrFilter"])) {
            $tmp = unserialize($_SESSION["AddrFilter"]);
            $this->Name = $tmp->Name;
            $this->Description = $tmp->Description;
            $this->NConds = $tmp->NConds;
            $this->Conditions = $tmp->Conditions;
        } else
            $this->Clear();
    }//ctor
    
    
    // Save to the session vars
    function Persist()
    {
        $_SESSION["AddrFilter"] =  serialize($this);
        $_SESSION["AddrFilterSQL"] = $this->SQL();
    }//Persist
    
    
    // Make en empty filter
    function Clear()
    {
        $this->Name = "";
        $this->Description = "";
        $this->NConds = 1;
        $this->Conditions[0] = new AddrCondition();
    }//Clear


    // check whethet the filter is empty
    function IsEmpty()
    {
        if ($this->NConds > 1)
            return false;
        if (empty($this->Conditions[0]))
            return true;
        $Cond = $this->Conditions[0];
        return $Cond->IsEmpty();
    }//IsEmpty
    
    
    // adds a new condition element
    function AddCondition($Cond)
    {
        if ($this->IsEmpty())
            $this->Conditions[0] = $Cond;
        else 
            $this->Conditions[$this->NConds++] = $Cond;
        $this->Name = "";
    }//AddCondition
    
    
    // adds a new condition element
    function MakeFromCondition($Cond)
    {
        $this->Clear();
        $this->Conditions[0] = $Cond;
    }//MakeFromCondition
    
    
    // Initialize filter from the form
    function InitFromForm()
    {
        global $reqNAddrConds, $reqIndentCondition, $reqUnindentCondition,
            $reqDelCondition, $reqCondType, $reqConnectiveType, $reqLevel,
            $reqAddr1, $reqAddr2, $reqAddr3, $reqAddr4, $reqMaskLen,
            $reqAddCondition, $reqAddrFilterName;
            
        import_request_variables("pg", "req");
        $this->NConds = $reqNAddrConds;
        
        for ($i1 = $i2 = 0; $i1 < $this->NConds; $i1++, $i2++) {
            if (isset($reqIndentCondition[$i2]))
                $reqLevel[$i2]++;
            elseif (isset($reqUnindentCondition[$i2]))
                $reqLevel[$i2]--;
            elseif (isset($reqDelCondition[$i2])) {
                $i1--; $this->NConds--;
                continue;
            }//if
                
            switch($reqCondType[$i2]) {
            case "src-eq":
                $AddrType = "src"; $CondType = "eq";
                break;
            case "src-ne":
                $AddrType = "src"; $CondType = "ne";
                break;
            case "dst-eq":
                $AddrType = "dst"; $CondType = "eq";
                break;
            case "dst-ne":
                $AddrType = "dst"; $CondType = "ne";
                break;
            }//switch
            
            $ConnectiveType = "&";
            if (isset($reqConnectiveType[$i2]))
                $ConnectiveType = $reqConnectiveType[$i2];
    
            $Condition = $this->Conditions[$i1] = 
                new AddrCondition($reqLevel[$i2], 
                                  $AddrType, $CondType,
                                  $reqAddr1[$i2], $reqAddr2[$i2], 
                                  $reqAddr3[$i2], $reqAddr4[$i2],
                                  $reqMaskLen[$i2], $ConnectiveType);
            
            if (isset($reqAddCondition[$i2])) {
                $this->NConds++; $i1++;
                $this->Conditions[$i1] = new AddrCondition();
            }//if
        }//for
        
        if (! empty($reqAddrFilterName)) {
            if (get_magic_quotes_gpc())
                $this->Name = stripslashes($reqAddrFilterName);
            else
                $this->Name = $reqAddrFilterName;
        }//if
    }//InitFromForm
    

    // Load from the database
    function Load($ID)
    {
        $Result = mysql_query("SELECT Name FROM AddrFilters 
                               WHERE ID = $ID");
        $Row = mysql_fetch_row($Result);
        $this->Name = $Row[0];
        mysql_free_result($Result);
                               
        $Result = mysql_query("SELECT * FROM AddrConditions 
                               WHERE FilterID = $ID
                               ORDER BY SeqN");
        $this->NConds = mysql_num_rows($Result);
        
        for ($i = 0; $Row = mysql_fetch_object($Result); $i++) {
            $Condition = new AddrCondition();
            $Condition->InitFromDBRow($Row);
            $this->Conditions[$i] = $Condition;
        }//while
        
        mysql_free_result($Result);
    }//Load
    

    // Load from the database
    function Delete()
    {
        if (get_magic_quotes_gpc())
            $Name = $this->Name;
        else
            $Name = mysql_real_escape_string($this->Name);
        
        mysql_query("START TRANSACTION");
        $Result = mysql_query("SELECT ID FROM AddrFilters 
                               WHERE Name = '$Name'");
        if (mysql_num_rows($Result) == 0)
            return;
        $Row = mysql_fetch_row($Result);
        $ID = $Row[0];

        mysql_query("DELETE FROM AddrConditions WHERE FilterID = $ID");
        mysql_query("DELETE FROM AddrFilters WHERE ID = $ID");
        mysql_query("COMMIT");
        $this->Clear();
    }//Delete
    
    
    // Save in the database
    function SaveAs()
    {
        if (get_magic_quotes_gpc())
            $Name = $this->Name;
        else
            $Name = mysql_real_escape_string($this->Name);
        
        mysql_query("START TRANSACTION");
        $Result = mysql_query("SELECT ID FROM AddrFilters 
                               WHERE Name = '$Name'");
        if (mysql_num_rows($Result)) {
            $Row = mysql_fetch_row($Result);
            $ID = $Row[0];
        } else {
            mysql_query("INSERT INTO AddrFilters (Name)
                         VALUES ('$Name')");
            $ID = mysql_insert_id();
        }//if

        mysql_query("DELETE FROM AddrConditions WHERE FilterID = $ID");
        for ($i = 0; $i < $this->NConds; $i++) {
            $Condition = $this->Conditions[$i];
            $Condition->SaveInDB($ID, $i);
        }//for
        
        mysql_query("COMMIT");
    }//SaveAs
    
    
    // Generate SQL WHERE clause
    function SQL()
    {
        $SQL = "";
        $PrevLevel = 0;
        
        for ($i = 0; $i < $this->NConds; $i++) {
            $Condition = $this->Conditions[$i];
            if (! $Condition->IsEmpty()) {
                $LevelDelta = $Condition->Level - $PrevLevel;
                if ($LevelDelta < 0)
                    $SQL .= str_repeat(")", -$LevelDelta);
                if ($SQL != "")
                    $SQL .= " ".$this->Conditions[$i - 1]->ConnectiveTypeStr()." ";
                if ($LevelDelta > 0)
                    $SQL .= str_repeat("(", $LevelDelta);
                $SQL .= $Condition->SQL();
            }//if
            
            $PrevLevel = $Condition->Level;
        }//for
    
        $LevelDelta = -$PrevLevel;
        if (! empty($SQL) && $LevelDelta < 0)
            $SQL .= str_repeat(")", -$LevelDelta);

        return $SQL;
    }//SQL
    
    
    // Generate HTML form for this filter
    function MakeFormHTML()
    {
?>
<!-- Address filter subpane -->
<fieldset>
<legend>IP-address filter&nbsp;</legend>
<table border="0" cellpadding="0" cellspacing="2">
<tr>
<td nowrap valign="middle"><select name="FilterList" id="FilterList">
<option value="-1"></option>
<?php
        $Result = mysql_query("SELECT ID, Name FROM AddrFilters ORDER BY Name");
        while ($Row = mysql_fetch_object($Result)) {
            echo "    <option value=\"$Row->ID\"".
                 (($Row->Name == $this->Name) ? " selected" : "").
                 ">".htmlspecialchars($Row->Name)."</option>\n";
        }//while
?>
</select>
<input type="submit" id="LoadFilter" name="LoadFilter" class="button" value="Load">
<?php if (! empty($this->Name)) { ?>
<script type="text/javascript" language="JavaScript">
<!--

function DeleteFilter_onclick()
{
    if (! confirm("Really delete filter \"<?= $this->Name ?>\"?"))
        window.event.returnValue = false;
}//DeleteFilter_onclick

-->
</script>
<input type="submit" id="DeleteFilter" name="DeleteFilter" class="button" value="Delete" onClick="DeleteFilter_onclick()"></td>
<?php }//if ?>
</td>
</tr>
<tr>
<td nowrap valign="middle"><input type="submit" id="SaveFilter" name="SaveFilter" class="button" value="Save as">
<input type="Text" name="AddrFilterName" id="AddrFilterName" size="24" class="input" value="<?= htmlspecialchars($this->Name) ?>"></td>
</tr>
</table>
<hr>
<input type="Hidden" name="NAddrConds" id="NAddrConds" value="<?= $this->NConds ?>">
<table border="0" cellpadding="0" cellspacing="0">
<?php
        for ($i = 0; $i < $this->NConds; $i++) {
            if (isset($this->Conditions[$i]))
                $Condition = $this->Conditions[$i];
            else
                $Condition = new AddrCondition();
                
            $CTSel = 0;
            if (substr($Condition->AddrType, 0, 1) != "s")
                $CTSel |= 2;
            if (substr($Condition->CondType, 0, 1) != "e")
                $CTSel |= 1;
                
            $Level = $Condition->Level;
            $Addr1 = $Condition->Addr[1];
            $Addr2 = $Condition->Addr[2];
            $Addr3 = $Condition->Addr[3];
            $Addr4 = $Condition->Addr[4];
            $MaskLen = $Condition->MaskLen;
            $ConnectiveType = $Condition->ConnectiveType;
?>
<tr><td>
    <table border="0" cellpadding="0" cellspacing="0">
    <tr>
    <td><input type="image" name="AddCondition[<?= $i ?>]" id="AddCondition" title="Add a new address condition" src="images/PlusButton.png"></td>
<?php
            if ($this->NConds <= 1) {
?>
        <td><img src="images/MinusButtonDisabled.png"></td>
<?php
            } else {
?>
        <td><input type="image" name="DelCondition[<?= $i ?>]" id="DelCondition" title="Delete this address condition" src="images/MinusButton.png"></td>
<?php
            }//if
?>
    </tr>
    <tr>
<?php
            if ($Level == 0) {
?>
    <td><img src="images/ArrowLeftButtonDisabled.png"></td>
<?php
            } else {
?>
    <td><input type="image" name="UnindentCondition[<?= $i ?>]" id="UnindentCondition" title="Move this condition up in the hierarchy" src="images/ArrowLeftButton.png"></td>
<?php
            }//if
?>
    <td><input type="image" name="IndentCondition[<?= $i ?>]" id="IndentCondition" title="Move this condition down in the hierarchy" src="images/ArrowRightButton.png"></td>
    </tr>
    </table>
</td>
<td nowrap>
<input type="Hidden" name="Level[<?= $i ?>]" id="Level" value="<?= $Level ?>">
<?= str_repeat("&nbsp;", $Level * 4) ?>
<select name="CondType[<?= $i ?>]" id="CondType">
	<option value="src-eq"<?= $CTSel == 0 ? " selected" : "" ?>>s =</option>
	<option value="src-ne"<?= $CTSel == 1 ? " selected" : "" ?>>s !=</option>
	<option value="dst-eq"<?= $CTSel == 2 ? " selected" : "" ?>>d =</option>
	<option value="dst-ne"<?= $CTSel == 3 ? " selected" : "" ?>>d !=</option>
</select>
<input id="Addr1" name="Addr1[<?= $i ?>]" type="Text" class="input" maxlength="3" style="text-align: right; width: 2em;" value="<?= $Addr1 ?>">
<input id="Addr2" name="Addr2[<?= $i ?>]" type="Text" class="input" maxlength="3" style="text-align: right; width: 2em;" value="<?= $Addr2 ?>">
<input id="Addr3" name="Addr3[<?= $i ?>]" type="Text" class="input" maxlength="3" style="text-align: right; width: 2em;" value="<?= $Addr3 ?>">
<input id="Addr4" name="Addr4[<?= $i ?>]" type="Text" class="input" maxlength="3" style="text-align: right; width: 2em;" value="<?= $Addr4 ?>">/<input id="MaskLen" name="MaskLen[<?= $i ?>]" type="Text" class="input" maxlength="2" style="width: 15pt; text-align: right;" value="<?= $MaskLen ?>">
<?php
            if ($i < $this->NConds - 1) {
?>
<select name="ConnectiveType[<?= $i ?>]" id="ConnectiveType">
	<option value="&"<?= $ConnectiveType == "&" ? " selected" : "" ?>>and</option>
	<option value="|"<?= $ConnectiveType == "|" ? " selected" : "" ?>>or</option>
</select>
<?php
            }//if
?>
</td>
</tr>
<?php
        }//for
?>
</table>
</fieldset>
<?php
    }//MakeFormHTML
}//AddrFilter

?>
