<?php
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: AddrGraph.php,v 1.1 2005/05/19 08:48:42 mpolk Exp $
| Address-based graph generator.                                        |
\----------------------------------------------------------------------*/

require_once("Globals.php"); 
require_once("Utils.php"); 
require_once("Settings.php"); 
require_once("TimeSelector.php"); 

LoadSettings();

// first determine whether we are invoked to draw a graph or just to translate
// click coordinates
$SelChangeMode = false;
if (isset($_SERVER["QUERY_STRING"])) {
    $SelChangeMode = preg_match("/^(\\d+),(\\d+)$/", $_SERVER["QUERY_STRING"], $Matches);
    if ($SelChangeMode) {
        $ClickX = $Matches[1];
        unset($_SESSION["AddrGraphForceZoom"]);
    }//if
}//if

// get runtime parameters
if (empty($_SESSION["AddrGraphType"]))
    $GraphType = "Src";
else
    $GraphType = $_SESSION["AddrGraphType"];
if (empty($_SESSION["AddrGraphSortType"]))
    $SortType = "ByAddress";
else
    $SortType = $_SESSION["AddrGraphSortType"];

    
// build SQL query
if (! empty($_SESSION["AddrFilterSQL"]))
    $AddrFilterSQL = $_SESSION["AddrFilterSQL"];
    
if ($GraphType == "Src") {
    $SortFields = "Src1, Src2, Src3, Src4";
    $GroupFields = "Src1, Src2, Src3, Src4";
} else {
    $SortFields = "Dst1, Dst2, Dst3, Dst4";
    $GroupFields = "Dst1, Dst2, Dst3, Dst4 ";
}//if

$TimeSelector = new TimeSelector();
$TimeCond = $TimeSelector->TimeConditionSQL();
if (! $TimeSelector->SelectionNotEmpty()) {
    foreach (array("Day", "Week", "Month", "Year") as $View) {
       $Result = mysql_query("SELECT UNIX_TIMESTAMP(Time), Age, ID
                              FROM ${View}Readouts ".
                              (empty($TimeCond) ? "" : "WHERE $TimeCond ").
                              "ORDER BY Time DESC
                              LIMIT 1");
       if (mysql_num_rows($Result)) {
           $Row = mysql_fetch_row($Result);
           $Time = $Row[0];
           $Age = $Row[1] * 60;
           $ActiveReadoutID = $Row[2];
           $ActiveView = $View;
           mysql_free_result($Result);
           break;
       }//if
       mysql_free_result($Result);
    }//foreach

    $Query = "SELECT SUM(".$_SESSION["TrafficUnits"].") / $Age AS Rate, $SortFields 
              FROM ${ActiveView}Data 
              WHERE (ReadoutID = $ActiveReadoutID)";
} else {
    $ActiveView = "Year";
    if ($TimeSelector->SelStart) {
        foreach (array("Day", "Week", "Month") as $View) {
            $Result = mysql_query("SELECT UNIX_TIMESTAMP(Time) - Age * 60
                                   FROM ${View}Readouts
                                   ORDER BY Time
                                   LIMIT 1");
            $Row = mysql_fetch_row($Result);
            $MinTime = $Row[0];
            mysql_free_result($Result);
            if ($MinTime <= $TimeSelector->SelStart) {
                $ActiveView = $View;
                break;
            }//if
        }//foreach
    }//if
    
    if (empty($MinTime)) {
        $Result = mysql_query("SELECT UNIX_TIMESTAMP(Time) - Age * 60
                               FROM ${ActiveView}Readouts
                               ORDER BY Time
                               LIMIT 1");
        $Row = mysql_fetch_row($Result);
        $MinTime = $Row[0];
        mysql_free_result($Result);
    }//if

    $Result = mysql_query("SELECT UNIX_TIMESTAMP(Time)
                           FROM ${ActiveView}Readouts
                           ORDER BY Time DESC
                           LIMIT 1");
    $Row = mysql_fetch_row($Result);
    $MaxTime = $Row[0];
    mysql_free_result($Result);

    $RateExpr = $TimeSelector->RateExpressionSQL($MinTime, $MaxTime);
    $Query = "SELECT $RateExpr AS Rate, $SortFields 
              FROM ${ActiveView}Data INNER JOIN ${ActiveView}Readouts
                  ON ${ActiveView}Data.ReadoutID = ${ActiveView}Readouts.ID
              WHERE $TimeCond";
}//if

if (! empty($AddrFilterSQL))
    $Query .= " AND (".$AddrFilterSQL.")";
$Query .= " GROUP BY $GroupFields";
if ($SortType == "ByAddress")
    $Query .= " ORDER BY $SortFields";
else
    $Query .= " ORDER BY Rate DESC";

//echo $Query;
//exit;

// fetch data
$Result = mysql_query($Query);
$TotalFlows = mysql_num_rows($Result);

// determine vertical image dimensions and sizes
$CharWidth = imagefontwidth(3);
$CharHeight = imagefontheight(3);
$TopMargin = 4;
$BottomMargin = $CharWidth;
$ImageHeight = GetIntSetting(ADDR_GRAPH_HEIGHT, DEF_ADDR_GRAPH_HEIGHT);

// determine traffic rate limit
$MaxRate = 10.0;
while ($Row = mysql_fetch_object($Result)) {
    $Rate = $Row->Rate;
    if ($Rate > $MaxRate)
        $MaxRate = $Rate;
}//while

$MaxRateLog = log10($MaxRate);
$MaxRateExp = (int)$MaxRateLog;
$MaxRateMantissa = pow(10.0, $MaxRateLog - $MaxRateExp);
if ($MaxRateMantissa <= 2.0) {
    $MaxRateMantissa = 2.0;
    $RateGrid = (int)(0.5 * pow(10.0, $MaxRateExp));
    $PixelsPerRateStep = (int)round(($ImageHeight - $TopMargin - $BottomMargin) / 4);
} elseif ($MaxRateMantissa <= 5.0) {
    $MaxRateMantissa = 5.0;
    $RateGrid = (int)(pow(10.0, $MaxRateExp));
    $PixelsPerRateStep = (int)round(($ImageHeight - $TopMargin - $BottomMargin) / 5);
} elseif ($MaxRateMantissa <= 8.0) {
    $MaxRateMantissa = 8.0;
    $RateGrid = (int)(2.0 * pow(10.0, $MaxRateExp));
    $PixelsPerRateStep = (int)round(($ImageHeight - $TopMargin - $BottomMargin) / 4);
} else {
    $MaxRateMantissa = 1.0;
    $RateGrid = (int)(2.0 * pow(10.0, $MaxRateExp));
    $PixelsPerRateStep = (int)round(($ImageHeight - $TopMargin - $BottomMargin) / 5);
    $MaxRateExp++;
}//if
$OrigMaxRate = $MaxRate;
$MaxRate = $MaxRateMantissa * pow(10.0, $MaxRateExp);
$RateScale = ($ImageHeight - $TopMargin - $BottomMargin) / $MaxRate;

// determine horizontal image dimensions and sizes
$LeftMargin = $CharWidth * (1 + $MaxRateExp);
$RightMargin = 0;
$ImageWidth1 = $ImageWidth = GetIntSetting(ADDR_GRAPH_WIDTH, DEF_ADDR_GRAPH_WIDTH);
$MaxImageWidth = GetIntSetting(MAX_ADDR_GRAPH_WIDTH, DEF_MAX_ADDR_GRAPH_WIDTH);
if (empty($_SESSION["AddrGraphPixelsPerFlow"])) {
    if ($TotalFlows == 0)
        $PixelsPerFlow = 0;
    else
        $PixelsPerFlow = (int)(($ImageWidth - $LeftMargin - $RightMargin) / $TotalFlows);
    if ($PixelsPerFlow < $CharHeight && $TotalFlows != 0) {
        $PixelsPerFlow = $CharHeight;
        $ImageWidth1 = $PixelsPerFlow * $TotalFlows + $LeftMargin + $RightMargin + 1;
    }//if
} elseif (! empty($_SESSION["AddrGraphForceZoom"]) &&
          $_SESSION["AddrGraphForceZoom"] == "in") {
    $PixelsPerFlow = $_SESSION["AddrGraphPixelsPerFlow"] * 2;
    $ImageWidth1 = $PixelsPerFlow * $TotalFlows + $LeftMargin + $RightMargin + 1;
} elseif (! empty($_SESSION["AddrGraphForceZoom"]) &&
          $_SESSION["AddrGraphForceZoom"] == "out") {
    $PixelsPerFlow = $_SESSION["AddrGraphPixelsPerFlow"];
    if ($PixelsPerFlow >= 3)
        $PixelsPerFlow = (int)($PixelsPerFlow / 2);
    $ImageWidth1 = $PixelsPerFlow * $TotalFlows + $LeftMargin + $RightMargin + 1;
} else {
    $PixelsPerFlow = $_SESSION["AddrGraphPixelsPerFlow"];
    $ImageWidth1 = $PixelsPerFlow * $TotalFlows + $LeftMargin + $RightMargin + 1;
}//if
if ($ImageWidth1 > $ImageWidth)
    $ImageWidth = $ImageWidth1;
if ($ImageWidth > $MaxImageWidth) {
    $ImageWidth = $MaxImageWidth;
    $PixelsPerFlow = (int)(($ImageWidth - $LeftMargin - $RightMargin) / $TotalFlows);
}//if

$ImageWidth;
$_SESSION["AddrGraphPixelsPerFlow"] = $PixelsPerFlow;
$OriginX = $LeftMargin;
$OriginY = $ImageHeight - $BottomMargin;

// start constructing the image
if (! $SelChangeMode) {
    $Img     = imagecreate($ImageWidth, $ImageHeight);
    $BgColor = imagecolorallocate($Img, 0xF5, 0xFF, 0xFA);
    imagefill($Img, 0, 0, $BgColor);
}//if

// draw the graph itself
if (! $SelChangeMode) {
    $AddrColor = imagecolorallocate($Img, 0, 0, 0);
    $GraphBorderColor = imagecolorallocate($Img, 0x00, 0x80, 0x40);
    $SelBorderColorRGB = GetIntSetting(ADDR_GRAPH_SEL_COLOR, DEF_ADDR_GRAPH_SEL_COLOR);
    $SelBorderColor = MakeColor($Img, $SelBorderColorRGB);
    $LowlandColorRGB = GetIntSetting(ADDR_GRAPH_L_COLOR, DEF_ADDR_GRAPH_L_COLOR);
    $LowlandColorR = ($LowlandColorRGB & 0xFF0000) >> 16;
    $LowlandColorG = ($LowlandColorRGB & 0xFF00) >> 8;
    $LowlandColorB = $LowlandColorRGB & 0xFF;
    $HighlandColorRGB = GetIntSetting(ADDR_GRAPH_H_COLOR, DEF_ADDR_GRAPH_H_COLOR);
    $HighlandColorR = ($HighlandColorRGB & 0xFF0000) >> 16;
    $HighlandColorG = ($HighlandColorRGB & 0xFF00) >> 8;
    $HighlandColorB = $HighlandColorRGB & 0xFF;
}//if
if ($TotalFlows)
    mysql_data_seek($Result, 0);
for ($i = 0; $Row = mysql_fetch_object($Result); $i++) {
    $Rate = $Row->Rate;
    
    $x0 = $OriginX + $PixelsPerFlow * $i;
    $x1 = $x0 + $PixelsPerFlow;
    $y0 = $OriginY - (int)round($Rate * $RateScale);
    
    if (! $SelChangeMode) {
        $InSelection = 
            ($GraphType == "Src" && isset($_SESSION["SelSrc1"]) &&
             $_SESSION["SelSrc1"] == $Row->Src1 &&
             $_SESSION["SelSrc2"] == $Row->Src2 &&
             $_SESSION["SelSrc3"] == $Row->Src3 &&
             $_SESSION["SelSrc4"] == $Row->Src4) ||
            ($GraphType == "Dst" && isset($_SESSION["SelDst1"]) &&
             $_SESSION["SelDst1"] == $Row->Dst1 &&
             $_SESSION["SelDst2"] == $Row->Dst2 &&
             $_SESSION["SelDst3"] == $Row->Dst3 &&
             $_SESSION["SelDst4"] == $Row->Dst4);

        $q1 = $Rate / $OrigMaxRate; $q2 = 1 - $q1;
        $R = (int)round($HighlandColorR * $q1 + $LowlandColorR * $q2);
        $G = (int)round($HighlandColorG * $q1 + $LowlandColorG * $q2);
        $B = (int)round($HighlandColorB * $q1 + $LowlandColorB * $q2);
        if ($InSelection) {
            $R = ($R + 255) / 2;
            $G = ($G + 255) / 2;
            $B = ($B + 255) / 2;
        }//if
        $Color = imagecolorexact($Img, (int)$R, (int)$G, (int)$B);
        if ($Color == -1)
            $Color = imagecolorallocate($Img, $R, $G, $B);
        
        imagefilledrectangle($Img, $x0, $y0, $x1, $OriginY, $Color);
        if (! $InSelection) 
            $Color = $GraphBorderColor;
        else {
            $Color = $SelBorderColor;
            imagerectangle($Img, $x0 + 1, $y0 + 1, $x1 - 1, $OriginY - 1, $Color);
        }//if
        imagerectangle($Img, $x0, $y0, $x1, $OriginY, $Color);
        
        if ($PixelsPerFlow >= $CharHeight) {
            if ($GraphType == "Src")
                $Addr = $Row->Src1.".".$Row->Src2.".".$Row->Src3.".".$Row->Src4;
            else
                $Addr = $Row->Dst1.".".$Row->Dst2.".".$Row->Dst3.".".$Row->Dst4;
            imagestringup($Img, 3, $x0 + ($PixelsPerFlow - $CharHeight) / 2, 
                          $ImageHeight - 2 * $CharWidth, $Addr, $AddrColor);
        }//if

    } elseif ($ClickX >= $x0 && $ClickX <= $x1) {
        if ($GraphType == "Src") {
            $_SESSION["SelSrc1"] = $Row->Src1;
            $_SESSION["SelSrc2"] = $Row->Src2;
            $_SESSION["SelSrc3"] = $Row->Src3;
            $_SESSION["SelSrc4"] = $Row->Src4;
        } else {
            $_SESSION["SelDst1"] = $Row->Dst1;
            $_SESSION["SelDst2"] = $Row->Dst2;
            $_SESSION["SelDst3"] = $Row->Dst3;
            $_SESSION["SelDst4"] = $Row->Dst4;
        }//if
        break;
    }//if
    
}//for

// if we were called just for changing the selection (by clicking on the image)
// we have nothing to do more
if ($SelChangeMode)
    Redirect(dirname($_SERVER["SCRIPT_NAME"])."/ByAddress.php?x-coord=$GraphType");

// Draw axes and grid
$AxisColor = MakeColor($Img, GetIntSetting(AXIS_COLOR, DEF_AXIS_COLOR));
$GridColor = MakeColor($Img, GetIntSetting(GRID_COLOR, DEF_GRID_COLOR));
$DashedLineStyle = array($GridColor, $BgColor);
imageline($Img, $OriginX, $OriginY, $ImageWidth - $RightMargin, $OriginY, $AxisColor);

imagesetstyle($Img, $DashedLineStyle);
imageline($Img, $OriginX, $OriginY, $OriginX, $TopMargin, $AxisColor);
for ($i = 1; $r = $i * $RateGrid, $r <= $MaxRate; $i++) {
    $y = $OriginY - $i * $PixelsPerRateStep;
    imageline($Img, $OriginX, $y, $ImageWidth - $RightMargin, $y, IMG_COLOR_STYLED);
    imagestring($Img, 3, 0, $y, $r, $AxisColor);
}//for

// print a brief explanation
imagestring($Img, 3, $OriginX + $CharWidth, $TopMargin, 
            $TotalFlows." flows from ".strtolower($ActiveView)." view", $GridColor);

// at last output image and destroy it
header("Content-type: image/png");
imagepng($Img);
imagedestroy($Img);
?>