<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: BrightnessPicker.php,v 1.1 2005/05/19 08:48:42 mpolk Exp $
| Monochrome brightness picker image.                                   |
\----------------------------------------------------------------------*/

require_once("Globals.php"); 

define("IMAGE_WIDTH", 250);
define("IMAGE_HEIGHT", 30);
define("ARROW_LENGTH", 8);
define("ARROW_WIDTH", 16);

$Brightness = $_GET["Value"];

$Img = imagecreate(IMAGE_WIDTH, IMAGE_HEIGHT);
$FrameColor = imagecolorallocate($Img, 96, 96, 96);
$TranspColor = imagecolorallocatealpha($Img, 0, 0, 0, 127);
imagefilledrectangle($Img, 0, 0, IMAGE_WIDTH - 1 , IMAGE_HEIGHT - 1, $TranspColor);
imagerectangle($Img, 0, ARROW_LENGTH, IMAGE_WIDTH - 1, IMAGE_HEIGHT - 1, $FrameColor);

$X0 = round($Brightness / 255 * (IMAGE_WIDTH - 2)) + 1;
$Y0 = ARROW_LENGTH;
$Coords = array($X0, $Y0, 
                $X0 - ARROW_WIDTH / 2, 0,
                $X0 + ARROW_WIDTH / 2, 0);
imagefilledpolygon($Img, $Coords, 3, $FrameColor);

$Y0 = ARROW_LENGTH + 1; $Y1 = IMAGE_HEIGHT - 2;
for ($i = 1; $i < IMAGE_WIDTH; $i++) {
    $X = $i;
    $L = round($i / (IMAGE_WIDTH - 2) * 255);
    $Color = imagecolorexact($Img, $L, $L, $L);
    if ($Color < 0)
        $Color = imagecolorallocate($Img, $L, $L, $L);
    imageline($Img, $X, $Y0, $X, $Y1, $Color);
}//for

header("Content-type: image/png");
imagepng($Img);
imagedestroy($Img);
?>