<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: BrightnessSelector.php,v 1.1 2005/05/19 08:48:42 mpolk Exp $
| Visual color brightness selector.                                     |
\----------------------------------------------------------------------*/

require_once("Globals.php"); 
require_once("Utils.php"); 
require_once("MainMenu.php"); 
require_once("Settings.php"); 

define("PICKER_WIDTH", 250);
define("PICKER_HEIGHT", 30);

if ($_SERVER["REQUEST_METHOD"] == "GET") {
    if (empty($_GET["Name"]) || empty($_GET["Value"]) || empty($_GET["Descr"])) {
        Redirect(dirname($_SERVER["SCRIPT_NAME"])."/ChangeSettings.php");
        exit;
    }//if
    
    $ColorName = $_SESSION["BrightnessSel.Name"] = $_GET["Name"];
    $BrightnessValue = $_SESSION["BrightnessSel.Value"] = $_GET["Value"];
    $ColorDescr = $_SESSION["BrightnessSel.Descr"] = $_GET["Descr"];
} else {
    $ColorName = $_SESSION["BrightnessSel.Name"];
    $BrightnessValue = $_SESSION["BrightnessSel.Value"];
    $ColorDescr = $_SESSION["BrightnessSel.Descr"];
}//if

if (isset($_POST["btnOk"])) {
    ChangeIntSetting($ColorName, $BrightnessValue);
    Redirect(dirname($_SERVER["SCRIPT_NAME"])."/ChangeSettings.php");
    exit;
}//if


if (isset($_POST["BrightnessPicker_x"])) {
    $X = $_POST["BrightnessPicker_x"] - 1;
    if ($X < 0)
        $X = 0;
    if ($X > PICKER_WIDTH - 2)
        $X = PICKER_WIDTH - 2;
    $BrightnessValue = round($X / (PICKER_WIDTH - 2) * 255);
    if ($BrightnessValue < 1)
        $BrightnessValue = 1;
    $_SESSION["BrightnessSel.Value"] = $BrightnessValue;
}//if

?>

<?= DTD ?>
<html>
<head>
<?php 
$Title = $ColorDescr;
include("PageHeader.php");
?>

<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="Fri, 12 Jan 2001 08:32:53 GMT">

<script type="text/javascript" language="JavaScript">
<!--
function btnCancel_onclick()
{
    location.href = "ChangeSettings.php";
}//btnCancel_onclick
-->
</script>

</head>
<body>
<form method="post">
<?php 
$HelpTopic = "BrightnessSelector";
include("PageTop.php");
?>
</form>

<?php
$MainMenu = new MainMenu();
$MainMenu->MakeHTML("Settings");

include("PageMiddle.php");
?>

<form method="post">
<table border="0" cellpadding="0" cellspacing="2">
<tr><td colspan="2">Select <?= strtolower($Title) ?>:</td></tr>
<tr>
<td valign="top">
    <input type="image" id="BrightnessPicker" name="BrightnessPicker" src="BrightnessPicker.php?Value=<?= $BrightnessValue ?>" border="0" align="left" style="cursor: crosshair;">
</td>
<td valign="bottom">
    L = <?= $BrightnessValue ?>
</td>
</tr>
<tr><td colspan="2" align="center">
    <input type="Submit" value="Ok" name="btnOk" id="btnOk">
    <input type="Button" value="Cancel" name="btnCancel" id="btnCancel" onclick="btnCancel_onclick()">
</td></tr>
</table>
</form>

<?php 
include("PageBottom.php");
?>
</body>
</html>
