<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: ByAddress.php,v 1.1 2005/05/19 08:48:42 mpolk Exp $
| Page displaying IP-address (source or destination) sweep graphs.      |
\----------------------------------------------------------------------*/

require_once("Globals.php"); 
require_once("Utils.php"); 
require_once("Settings.php"); 
require_once("AddrFilter.php"); 
require_once("TimeSelector.php"); 

LoadSettings();

// Initialize "persistent" variables from the session data
$AddrFilter = new AddrFilter();
$TimeSelector = new TimeSelector();

$SortType = "ByRate";
if (! empty($_SESSION["AddrGraphSortType"]))
    $SortType = $_SESSION["AddrGraphSortType"];
    
// Then refresh variables from HTTP request fields
import_request_variables("pg", "req");
if (empty($_GET["x-coord"]) || strncasecmp($_GET["x-coord"], "s", 1) == 0) {
    $GraphType = "Src";
    $Title = "Traffic distribution by source address";
} else {
    $GraphType = "Dst";
    $Title = "Traffic distribution by destination address";
}//if

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $AddrFilter->InitFromForm();
    $TimeSelector->ProcessFormInput();
    
    if (isset($reqSortType))
        $SortType = $reqSortType;
}//if

// Load address filter if required...
if (isset($_POST["LoadFilter"])) {
    if ($reqFilterList < 0)
        $AddrFilter->Clear();
    else
        $AddrFilter->Load($reqFilterList);
    unset($_SESSION["AddrGraphPixelsPerFlow"]);
}//if

// ...or make it from the selected address
if (isset($_POST["MakeFilterFromSel$GraphType"])) {
    $AddrFilter->MakeFromCondition(
        new AddrCondition(0, $GraphType, "eq",
            $_SESSION["Sel${GraphType}1"], $_SESSION["Sel${GraphType}2"], 
            $_SESSION["Sel${GraphType}3"], $_SESSION["Sel${GraphType}4"],
            32));
    unset($_SESSION["AddrGraphPixelsPerFlow"]);
} elseif (isset($_POST["AddSel${GraphType}ToFilter"])) {
    $AddrFilter->AddCondition(
        new AddrCondition(0, $GraphType, "eq",
            $_SESSION["Sel${GraphType}1"], $_SESSION["Sel${GraphType}2"], 
            $_SESSION["Sel${GraphType}3"], $_SESSION["Sel${GraphType}4"],
            32));
    unset($_SESSION["AddrGraphPixelsPerFlow"]);
} elseif (isset($_POST["DeselectAddress"])) {
    unset($_SESSION["Sel${GraphType}1"]);
    unset($_SESSION["Sel${GraphType}2"]);
    unset($_SESSION["Sel${GraphType}3"]);
    unset($_SESSION["Sel${GraphType}4"]);
}//if


if ($AddrFilter->NConds < 1)
    $AddrFilter->Clear();

// Build address filter SQL string
$AddrFilterSQL = $AddrFilter->SQL();

// Save or delete address filter in database if required
if (isset($_POST["SaveFilter"])) {
    if (empty($AddrFilter->Name))
        $Alert = "Please specify a filter name!";
    else 
        $AddrFilter->SaveAs();
} elseif (isset($_POST["DeleteFilter"])) {
    $AddrFilter->Delete();
}//if

$AddrFilter->Persist();
$_SESSION["AddrGraphType"] = $GraphType;
$_SESSION["AddrGraphSortType"] = $SortType;

// Send graphing module a signal to zoom in/out if required
if (isset($_POST["ZoomIn"]))
    $_SESSION["AddrGraphForceZoom"] = "in";
elseif (isset($_POST["ZoomOut"]))
    $_SESSION["AddrGraphForceZoom"] = "out";
else {
    unset($_SESSION["AddrGraphForceZoom"]);
    if ($_SERVER["REQUEST_METHOD"] != "POST" || isset($_POST["ResetScale"]))
        unset($_SESSION["AddrGraphPixelsPerFlow"]);
}//if

?>
<?= DTD ?>
<html>
<head>
<?php 
$TimeSelector = new TimeSelector();
if ($TimeSelector->Cursor == 0)
    AutoRefresh(GetIntSetting(DAY_VIEW_GRID, 5) * 60);
include("PageHeader.php");
?>
</head>

<body<?= empty($Alert) ? "" : " onload=\"alert('$Alert')\"" ?>>
<form name="QueryForm" id="QueryForm" method="post">
<?php 
$HelpTopic = "AddressGraph";
$SelectedTopButton = $GraphType;
$ShowTrafficUnitSelector = true;
include("PageTop.php");
?>

<input type="submit" id="GraphIt" name="GraphIt" class="button" value="Graph it" accesskey="G" style="margin-left: 2pt; margin-top: 2pt;">
<?php
$AddrFilter->MakeFormHTML();
?>

<!-- Sort subpane -->
<fieldset>
<legend>&nbsp;Sort&nbsp;</legend>
<div align="center">
<input type="Radio" name="SortType" id="SortByAddress" value="ByAddress"<?= ($SortType == "ByAddress") ? " checked" : "" ?>>
<label for="SortByAddress" accesskey="a">by <u>a</u>ddress</label>
<input type="Radio" name="SortType" id="SortByRate" value="ByRate"<?= ($SortType == "ByRate") ? " checked" : "" ?>>
<label for="SortByRate" accesskey="r">by <u>r</u>ate</label>
</div>
</fieldset>

<!-- Scale subpane -->
<fieldset>
<legend>&nbsp;Scale&nbsp;</legend>
<div align="center">
<input type="Submit" name="ZoomIn" id="ZoomIn" value="Zoom In" class="button">
<input type="Submit" name="ZoomOut" id="ZoomOut" value="Zoom Out" class="button">
<input type="Submit" name="ResetScale" id="ResetScale" value="Reset" class="button">
</div>
</fieldset>

<?php
if (isset($_SESSION["Sel${GraphType}1"])) {
    $Addr1 = $_SESSION["Sel${GraphType}1"];
    $Addr2 = $_SESSION["Sel${GraphType}2"];
    $Addr3 = $_SESSION["Sel${GraphType}3"];
    $Addr4 = $_SESSION["Sel${GraphType}4"];
    $Addr = $Addr1.".".$Addr2.".".$Addr3.".".$Addr4;
    $HostName = gethostbyaddr($Addr);
?>
<!-- Address selection subpane -->
<fieldset>
<legend>&nbsp;Selection&nbsp;</legend>
<div align="center">
<?= $Addr."<br>".(($HostName == $Addr) ? "" : "($HostName)<br>") ?>
<input type="Submit" name="MakeFilterFromSel<?= $GraphType ?>" id="MakeFilterFromSel<?= $GraphType ?>" value="Make filter" class="button">
<input type="Submit" name="AddSel<?= $GraphType ?>ToFilter" id="AddSel<?= $GraphType ?>ToFilter" value="Add to filter" class="button">
<br>
<input type="Submit" name="DeselectAddress" id="DeselectAddress" class="button" value="Deselect">
</div>
</fieldset>
<?php
}//if
?>

<?php 
include("PageMiddle.php");
?>

<?= $Title.", ".strtolower($_SESSION["TrafficUnits"]) ?>/s<br>
<a href="AddrGraph.php"><img src="AddrGraph.php" ismap border="0"></a>

<?php 
include("PageBottom.php");
?>
</form>
</body>
</html>
