<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: ByTime.php,v 1.1 2005/05/19 08:48:42 mpolk Exp $
| Page displaying time sweep graphs.                                    |
\----------------------------------------------------------------------*/

require_once("Globals.php"); 
require_once("Utils.php"); 
require_once("Settings.php"); 
require_once("AddrFilter.php"); 
require_once("TimeSelector.php"); 

LoadSettings();

$Title = "Time graph";
$TimeSelector = new TimeSelector();

$DayViewGrid = GetTimeSetting(DAY_VIEW_GRID, DEF_DAY_VIEW_GRID);
$WeekViewGrid = GetTimeSetting(WEEK_VIEW_GRID, DEF_WEEK_VIEW_GRID);
$MonthViewGrid = GetTimeSetting(MONTH_VIEW_GRID, DEF_MONTH_VIEW_GRID);
$YearViewGrid = GetTimeSetting(YEAR_VIEW_GRID, DEF_YEAR_VIEW_GRID);

// Initialize "persistent" variables from the session data
$ShowDayView = true;
if (isset($_SESSION["ShowDayView"]))
    $ShowDayView = $_SESSION["ShowDayView"];
$ShowWeekView = false;
if (isset($_SESSION["ShowWeekView"]))
    $ShowWeekView = $_SESSION["ShowWeekView"];
$ShowMonthView = false;
if (isset($_SESSION["ShowMonthView"]))
    $ShowMonthView = $_SESSION["ShowMonthView"];
$ShowYearView = false;
if (isset($_SESSION["ShowYearView"]))
    $ShowYearView = $_SESSION["ShowYearView"];
    
$AddrFilter = new AddrFilter();
    
// Then refresh variables from HTTP request fields
import_request_variables("pg", "req");

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $ShowDayView = ! empty($reqShowDayView);
    $_SESSION["ShowDayView"] = $ShowDayView;
    $ShowWeekView = ! empty($reqShowWeekView);
    $_SESSION["ShowWeekView"] = $ShowWeekView;
    $ShowMonthView = ! empty($reqShowMonthView);
    $_SESSION["ShowMonthView"] = $ShowMonthView;
    $ShowYearView = ! empty($reqShowYearView);
    $_SESSION["ShowYearView"] = $ShowYearView;
    
    $AddrFilter->InitFromForm();
    $TimeSelector->ProcessFormInput();
}//if


// move the time mark if one of the graphs was clicked
if (isset($_POST["DayGraph_x"])) {
    $GraphToSetTimeFrom = "Day";
    $ClickX = $_POST["DayGraph_x"];
} elseif (isset($_POST["WeekGraph_x"])) {
    $GraphToSetTimeFrom = "Week";
    $ClickX = $_POST["WeekGraph_x"];
} elseif (isset($_POST["MonthGraph_x"])) {
    $GraphToSetTimeFrom = "Month";
    $ClickX = $_POST["MonthGraph_x"];
} elseif (isset($_POST["YearGraph_x"])) {
    $GraphToSetTimeFrom = "Year";
    $ClickX = $_POST["YearGraph_x"];
}//if

if (isset($GraphToSetTimeFrom)) {
    $Tmin = $_SESSION["${GraphToSetTimeFrom}GraphTmin"];
    $Xmin = $_SESSION["${GraphToSetTimeFrom}GraphXmin"];
    $Xmax = $_SESSION["${GraphToSetTimeFrom}GraphXmax"];
    $TimeScale = $_SESSION["${GraphToSetTimeFrom}GraphTimeScale"];
    
    $T = (int)($Tmin + ($ClickX - $Xmin) / $TimeScale);
    $TimeSelector->SetCursor($T);
}//if


// Load address filter if required
if (isset($_POST["LoadFilter"])) {
    if ($reqFilterList < 0)
        $AddrFilter->Clear();
    else
        $AddrFilter->Load($reqFilterList);
}//if

if ($AddrFilter->NConds < 1)
    $AddrFilter->Clear();

// Build address filter SQL string
$AddrFilterSQL = $AddrFilter->SQL();

// Save or delete address filter in database if required
if (isset($_POST["SaveFilter"])) {
    if (empty($AddrFilter->Name))
        $Alert = "Please specify a filter name!";
    else 
        $AddrFilter->SaveAs();
} elseif (isset($_POST["DeleteFilter"])) {
    $AddrFilter->Delete();
}//if

$AddrFilter->Persist();

?>
<?= DTD ?>
<html>
<head>
<?php 
include("PageHeader.php");

if ($ShowDayView)
    AutoRefresh(GetIntSetting(DAY_VIEW_GRID, 5) * 60);
?>
</head>

<body<?= empty($Alert) ? "" : " onload=\"alert('$Alert')\"" ?>>
<form name="QueryForm" id="QueryForm" method="post">

<?php 
$HelpTopic = "TimeGraph";
$SelectedTopButton = "Time";
$ShowTrafficUnitSelector = true;
include("PageTop.php");
?>

<input type="submit" id="GraphIt" name="GraphIt" class="button" value="Graph it" style="margin-left: 2pt; margin-top: 2pt;">

<?php
$AddrFilter->MakeFormHTML();
?>

<fieldset>
<legend>Views&nbsp;</legend>
<input type="Checkbox" id="ShowDayView" name="ShowDayView"<?= $ShowDayView ? " checked" : "" ?>><label for="ShowDayView">Day</label>
<input type="Checkbox" id="ShowWeekView" name="ShowWeekView"<?= $ShowWeekView ? " checked" : "" ?>><label for="ShowWeekView">Week</label>
<input type="Checkbox" id="ShowMonthView" name="ShowMonthView"<?= $ShowMonthView ? " checked" : "" ?>><label for="ShowMonthView">Month</label>
<input type="Checkbox" id="ShowYearView" name="ShowYearView"<?= $ShowYearView ? " checked" : "" ?>><label for="ShowYearView">Year</label>
</fieldset>

<?php 
include("PageMiddle.php");
?>

<?php 
if (isset($_POST["AddCondition"]) || isset($_POST["DelCondition"]) ||
    isset($_POST["IndentCondition"]) || isset($_POST["UnindentCondition"])) {
?>
<span style="text-align: center;">Click "Graph it" button on the left pane to display traffic statistic graphs
after you adjust IP-address selection conditions.</span>
<?php 
} else {

    $AtLeastOneGraphDisplayed = false;
    
    if ($ShowDayView) {
        $AtLeastOneGraphDisplayed = true;
?>
Day traffic (<?= strtolower($_SESSION["TrafficUnits"]) ?>/sec, <?= $DayViewGrid / 60 ?> minute average)<br>
<input type="image" name="DayGraph" id="DayGraph" title="Click to set time cursor here" src="TimeGraph.php?Type=Day">
<?php
    }//if
    
    if ($ShowWeekView) {
        if ($AtLeastOneGraphDisplayed)
            echo "<hr>\n";
        $AtLeastOneGraphDisplayed = true;
?>
Week traffic (<?= strtolower($_SESSION["TrafficUnits"]) ?>/sec, <?= $WeekViewGrid / 60 ?> minute average)<br>
<input type="image" name="WeekGraph" id="WeekGraph" title="Click to set time cursor here"  src="TimeGraph.php?Type=Week">
<?php
    }//if

    if ($ShowMonthView) {
        if ($AtLeastOneGraphDisplayed)
            echo "<hr>\n";
        $AtLeastOneGraphDisplayed = true;
?>
Month traffic (<?= strtolower($_SESSION["TrafficUnits"]) ?>/sec, <?= $MonthViewGrid / 3600 ?> hour average)<br>
<input type="image" name="MonthGraph" id="MonthGraph" title="Click to set time cursor here"  src="TimeGraph.php?Type=Month">
<?php
    }//if
    
    if ($ShowYearView) {
        if ($AtLeastOneGraphDisplayed)
            echo "<hr>\n";
        $AtLeastOneGraphDisplayed = true;
?>
Year traffic (<?= strtolower($_SESSION["TrafficUnits"]) ?>/sec, <?= $YearViewGrid / 86400 ?> day average)<br>
<input type="image" name="YearGraph" id="YearGraph" title="Click to set time cursor here"  src="TimeGraph.php?Type=Year">
<?php
    }//if
}//if
?>

<?php 
include("PageBottom.php");
?>
</form>
</body>
</html>
