<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: ChangeSettings.php,v 1.1 2005/05/19 08:48:42 mpolk Exp $
| Global setting control page.                                          |
\----------------------------------------------------------------------*/

require_once("Globals.php"); 
require_once("MainMenu.php"); 
require_once("Settings.php"); 

LoadSettings();

if (isset($_POST["SetForThisSession"])) {
    ChangeIntSetting(DAY_VIEW_GRID, $_POST["DayViewGrid"]);
    ChangeCharSetting(DAY_VIEW_GRID, $_POST["DayGridUnit"]);
    ChangeIntSetting(DAY_VIEW_WINDOW, $_POST["DayViewWindow"]);
    ChangeCharSetting(DAY_VIEW_WINDOW, $_POST["DayWindowUnit"]);
    ChangeIntSetting(WEEK_VIEW_GRID, $_POST["WeekViewGrid"]);
    ChangeCharSetting(WEEK_VIEW_GRID, $_POST["WeekGridUnit"]);
    ChangeIntSetting(WEEK_VIEW_WINDOW, $_POST["WeekViewWindow"]);
    ChangeCharSetting(WEEK_VIEW_WINDOW, $_POST["WeekWindowUnit"]);
    ChangeIntSetting(MONTH_VIEW_GRID, $_POST["MonthViewGrid"]);
    ChangeCharSetting(MONTH_VIEW_GRID, $_POST["MonthGridUnit"]);
    ChangeIntSetting(MONTH_VIEW_WINDOW, $_POST["MonthViewWindow"]);
    ChangeCharSetting(MONTH_VIEW_WINDOW, $_POST["MonthWindowUnit"]);
    ChangeIntSetting(YEAR_VIEW_GRID, $_POST["YearViewGrid"]);
    ChangeCharSetting(YEAR_VIEW_GRID, $_POST["YearGridUnit"]);
    ChangeIntSetting(YEAR_VIEW_WINDOW, $_POST["YearViewWindow"]);
    ChangeCharSetting(YEAR_VIEW_WINDOW, $_POST["YearWindowUnit"]);

    ChangeIntSetting(TIME_GRAPH_WIDTH, $_POST["TimeGraphWidth"]);
    ChangeIntSetting(TIME_GRAPH_HEIGHT, $_POST["TimeGraphHeight"]);
    ChangeIntSetting(TIME_GRAPH_DAY_BRIGHTNESS, $_POST["TimeGraphDayBrightness"]);
    ChangeIntSetting(TIME_GRAPH_NIGHT_BRIGHTNESS, $_POST["TimeGraphNightBrightness"]);
    ChangeIntSetting(TIME_GRAPH_WINTER_COLOR, $_POST["TimeGraphWinterColor"]);
    ChangeIntSetting(TIME_GRAPH_SUMMER_COLOR, $_POST["TimeGraphSummerColor"]);
    ChangeIntSetting(TIME_GRAPH_SEL_COLOR, $_POST["TimeGraphSelColor"]);
    ChangeIntSetting(TIME_GRAPH_CURSOR_COLOR, $_POST["TimeGraphCursorColor"]);

    ChangeIntSetting(ADDR_GRAPH_WIDTH, $_POST["AddrGraphWidth"]);
    ChangeIntSetting(ADDR_GRAPH_HEIGHT, $_POST["AddrGraphHeight"]);
    ChangeIntSetting(MAX_ADDR_GRAPH_WIDTH, $_POST["MaxAddrGraphWidth"]);
    ChangeIntSetting(ADDR_GRAPH_H_COLOR, $_POST["AddrGraphHColor"]);
    ChangeIntSetting(ADDR_GRAPH_L_COLOR, $_POST["AddrGraphLColor"]);
    ChangeIntSetting(ADDR_GRAPH_SEL_COLOR, $_POST["AddrGraphSelColor"]);
}//if

if (isset($_POST["Save"])) {
    SaveIntSetting(DAY_VIEW_GRID, $_POST["DayViewGrid"]);
    SaveCharSetting(DAY_VIEW_GRID, $_POST["DayGridUnit"]);
    SaveIntSetting(DAY_VIEW_WINDOW, $_POST["DayViewWindow"]);
    SaveCharSetting(DAY_VIEW_WINDOW, $_POST["DayWindowUnit"]);
    SaveIntSetting(WEEK_VIEW_GRID, $_POST["WeekViewGrid"]);
    SaveCharSetting(WEEK_VIEW_GRID, $_POST["WeekGridUnit"]);
    SaveIntSetting(WEEK_VIEW_WINDOW, $_POST["WeekViewWindow"]);
    SaveCharSetting(WEEK_VIEW_WINDOW, $_POST["WeekWindowUnit"]);
    SaveIntSetting(MONTH_VIEW_GRID, $_POST["MonthViewGrid"]);
    SaveCharSetting(MONTH_VIEW_GRID, $_POST["MonthGridUnit"]);
    SaveIntSetting(MONTH_VIEW_WINDOW, $_POST["MonthViewWindow"]);
    SaveCharSetting(MONTH_VIEW_WINDOW, $_POST["MonthWindowUnit"]);
    SaveIntSetting(YEAR_VIEW_GRID, $_POST["YearViewGrid"]);
    SaveCharSetting(YEAR_VIEW_GRID, $_POST["YearGridUnit"]);
    SaveIntSetting(YEAR_VIEW_WINDOW, $_POST["YearViewWindow"]);
    SaveCharSetting(YEAR_VIEW_WINDOW, $_POST["YearWindowUnit"]);

    SaveIntSetting(TIME_GRAPH_WIDTH, $_POST["TimeGraphWidth"]);
    SaveIntSetting(TIME_GRAPH_HEIGHT, $_POST["TimeGraphHeight"]);
    SaveIntSetting(TIME_GRAPH_DAY_BRIGHTNESS, $_POST["TimeGraphDayBrightness"]);
    SaveIntSetting(TIME_GRAPH_NIGHT_BRIGHTNESS, $_POST["TimeGraphNightBrightness"]);
    SaveIntSetting(TIME_GRAPH_WINTER_COLOR, $_POST["TimeGraphWinterColor"]);
    SaveIntSetting(TIME_GRAPH_SUMMER_COLOR, $_POST["TimeGraphSummerColor"]);
    SaveIntSetting(TIME_GRAPH_SEL_COLOR, $_POST["TimeGraphSelColor"]);
    SaveIntSetting(TIME_GRAPH_CURSOR_COLOR, $_POST["TimeGraphCursorColor"]);

    SaveIntSetting(ADDR_GRAPH_WIDTH, $_POST["AddrGraphWidth"]);
    SaveIntSetting(ADDR_GRAPH_HEIGHT, $_POST["AddrGraphHeight"]);
    SaveIntSetting(MAX_ADDR_GRAPH_WIDTH, $_POST["MaxAddrGraphWidth"]);
    SaveIntSetting(ADDR_GRAPH_H_COLOR, $_POST["AddrGraphHColor"]);
    SaveIntSetting(ADDR_GRAPH_L_COLOR, $_POST["AddrGraphLColor"]);
    SaveIntSetting(ADDR_GRAPH_SEL_COLOR, $_POST["AddrGraphSelColor"]);
}//if

function TimeUnitCombo($Name, $Value)
{
    $Result = "<select name=\"$Name\" id=\"$Name\">";
    foreach (array("sec", "min", "hours", 
                   "days", "weeks", "months", "years") as $Unit) {
        $Result .= "<option".
                   ((strncasecmp($Unit, $Value, 2) == 0) ? " selected" : "").
                   ">$Unit</option>";
    }//foreach
    $Result .= "</select>";
    return $Result;
}//TimeUnitCombo


function ViewParamTableRow($View, $GridValue, $GridUnit, $WindowValue, $WindowUnit)
{
?>
<tr>
  <td><label for="<?= $View ?>ViewGrid"><?= $View ?></label></td>
  <td align="right"><input type="text" name="<?= $View ?>ViewGrid" id="<?= $View ?>ViewGrid" class="input" size="2" style="text-align: right;" value="<?= $GridValue ?>">
                    <?= TimeUnitCombo($View."GridUnit", $GridUnit) ?></td>
  <td align="right"><input type="text" name="<?= $View ?>ViewWindow" id="<?= $View ?>ViewWindow" class="input" size="2" style="text-align: right;" value="<?= $WindowValue ?>">
                    <?= TimeUnitCombo($View."WindowUnit", $WindowUnit) ?></td>
</tr>
<?php
}//ViewParamTableRow


function ColorSelector($Name, $DefValue, $Label)
{
    $Col = GetIntSetting($Name, $DefValue);
    $Color = sprintf("%06X", $Col);
?>
    <label for="<?= $Name ?>"><?= $Label ?>:</label>
    <input type="Text" name="<?= $Name ?>" id="<?= $Name ?>" class="input" size="8" style="text-align: right;" value="0x<?= $Color ?>">
    <a href="ColorSelector.php?Name=<?= $Name ?>&Value=<?= $Col ?>&Descr=<?= urlencode($Label) ?>">
    <span style="border: 1px solid Black; background: #<?= $Color ?>;">&nbsp;&nbsp;&nbsp;</span>
    </a>
<?php
}//ColorSelector


function BrightnessSelector($Name, $DefValue, $Label)
{
    $Br = GetIntSetting($Name, $DefValue);
    $Brightness = sprintf("%d", $Br);
    $Color = sprintf("%06X", ($Br << 16) | ($Br << 8) | $Br);
?>
    <label for="<?= $Name ?>"><?= $Label ?>:</label>
    <input type="Text" name="<?= $Name ?>" id="<?= $Name ?>" class="input" size="8" style="text-align: right;" value="<?= $Brightness ?>">
    <a href="BrightnessSelector.php?Name=<?= $Name ?>&Value=<?= $Br ?>&Descr=<?= urlencode($Label) ?>">
    <span style="border: 1px solid Black; background: #<?= $Color ?>;">&nbsp;&nbsp;&nbsp;</span>
    </a>
<?php
}//BrightnessSelector

?>

<?= DTD ?>
<html>
<head>
<?php 
$Title = "Settings";
include("PageHeader.php");
?>
</head>
<body>
<form method="post">
<?php 
$HelpTopic = "Settings";
include("PageTop.php");
?>
</form>

<?php
$MainMenu = new MainMenu();
$MainMenu->MakeHTML("Settings");

include("PageMiddle.php");
?>
<form method="post">
<table border="0" cellspacing="0" cellpadding="0">
<tr><td>
<fieldset>
<legend>&nbsp;View parameters&nbsp;</legend>
<table border="0" cellspacing="0" cellpadding="3">
<tr><th></th><th>Grid step</th><th>Window size</th></tr>
<?php
ViewParamTableRow("Day", 
                  GetIntSetting(DAY_VIEW_GRID, DEF_DAY_VIEW_GRID), 
                  GetCharSetting(DAY_VIEW_GRID, "seconds"),
                  GetIntSetting(DAY_VIEW_WINDOW, DEF_DAY_VIEW_WINDOW), 
                  GetCharSetting(DAY_VIEW_WINDOW, "seconds"));
ViewParamTableRow("Week", 
                  GetIntSetting(WEEK_VIEW_GRID, DEF_WEEK_VIEW_GRID), 
                  GetCharSetting(WEEK_VIEW_GRID, "seconds"),
                  GetIntSetting(WEEK_VIEW_WINDOW, DEF_WEEK_VIEW_WINDOW), 
                  GetCharSetting(WEEK_VIEW_WINDOW, "seconds"));
ViewParamTableRow("Month", 
                  GetIntSetting(MONTH_VIEW_GRID, DEF_MONTH_VIEW_GRID), 
                  GetCharSetting(MONTH_VIEW_GRID, "seconds"),
                  GetIntSetting(MONTH_VIEW_WINDOW, DEF_MONTH_VIEW_WINDOW), 
                  GetCharSetting(MONTH_VIEW_WINDOW, "seconds"));
ViewParamTableRow("Year", 
                  GetIntSetting(YEAR_VIEW_GRID, DEF_YEAR_VIEW_GRID), 
                  GetCharSetting(YEAR_VIEW_GRID, "seconds"),
                  GetIntSetting(YEAR_VIEW_WINDOW, DEF_YEAR_VIEW_WINDOW), 
                  GetCharSetting(YEAR_VIEW_WINDOW, "seconds"));
?>
</table>
</fieldset>
</td></tr>

<tr><td>
<fieldset>
<legend>&nbsp;Common colors&nbsp;</legend>
<?php ColorSelector(AXIS_COLOR, DEF_AXIS_COLOR, "Axis color") ?>
<span style="white-space: pre;">    </span>
<?php ColorSelector(GRID_COLOR, DEF_GRID_COLOR, "Grid color") ?>
<span style="white-space: pre;">    </span>
</fieldset>

<fieldset>
<legend>&nbsp;Time graph&nbsp;</legend>
<table border="0" cellspacing="0" cellpadding="3">
<tr>
<td align="right">
<label for="TimeGraphWidth">Width (max):</label>
<input type="Text" name="TimeGraphWidth" id="TimeGraphWidth" class="input" size="2" style="text-align: right;" value="<?= GetIntSetting(TIME_GRAPH_WIDTH, DEF_TIME_GRAPH_WIDTH) ?>">px
</td>
<td align="right">
<label for="TimeGraphHeight">Height:</label>
<input type="Text" name="TimeGraphHeight" id="TimeGraphHeight" class="input" size="2" style="text-align: right;" value="<?= GetIntSetting(TIME_GRAPH_HEIGHT, DEF_TIME_GRAPH_HEIGHT) ?>">px
</td>
</tr>
<tr>
<td align="right">
<?php ColorSelector(TIME_GRAPH_WINTER_COLOR, DEF_TIME_GRAPH_WINTER_COLOR, "Winter color") ?>
</td>
<td align="right">
<?php ColorSelector(TIME_GRAPH_SUMMER_COLOR, DEF_TIME_GRAPH_SUMMER_COLOR, "Summer color") ?>
</td>
</tr>
<tr>
<td align="right">
<?php 
    BrightnessSelector(TIME_GRAPH_DAY_BRIGHTNESS, DEF_TIME_GRAPH_DAY_BRIGHTNESS,
                       "Day brightness");
?>
</td>
<td align="right">
<?php 
    BrightnessSelector(TIME_GRAPH_NIGHT_BRIGHTNESS, DEF_TIME_GRAPH_NIGHT_BRIGHTNESS, 
                       "Night brightness");
?>
</td>
</tr>
<tr>
<td align="right">
<?php ColorSelector(TIME_GRAPH_SEL_COLOR, DEF_TIME_GRAPH_SEL_COLOR, "Selection color") ?>
</td>
<td align="right">
<?php ColorSelector(TIME_GRAPH_CURSOR_COLOR, DEF_TIME_GRAPH_CURSOR_COLOR, "Cursor color") ?>
</td>
</tr>
</table>
</fieldset>
</td></tr>

<tr><td>
<fieldset>
<legend>&nbsp;Address graph&nbsp;</legend>
<table border="0" cellspacing="0" cellpadding="3">
<tr>
<td align="right">
<label for="AddrGraphWidth">Width (min):</label>
<input type="Text" name="AddrGraphWidth" id="AddrGraphWidth" class="input" size="2" style="text-align: right;" value="<?= GetIntSetting(ADDR_GRAPH_WIDTH, DEF_ADDR_GRAPH_WIDTH) ?>">px
</td>
<td align="right">
<label for="AddrGraphHeight">Height:</label>
<input type="Text" name="AddrGraphHeight" id="AddrGraphHeight" class="input" size="2" style="text-align: right;" value="<?= GetIntSetting(ADDR_GRAPH_HEIGHT, DEF_ADDR_GRAPH_HEIGHT) ?>">px
</td>
<td align="right">
<label for="MaxAddrGraphWidth">Maximum width:</label>
<input type="Text" name="MaxAddrGraphWidth" id="MaxAddrGraphWidth" class="input" size="4" style="text-align: right;" value="<?= GetIntSetting(MAX_ADDR_GRAPH_WIDTH, DEF_MAX_ADDR_GRAPH_WIDTH) ?>">px
</td>
</tr>
<tr>
<td align="right">
<?php ColorSelector(ADDR_GRAPH_L_COLOR, DEF_ADDR_GRAPH_L_COLOR, "Lowland color") ?>
</td>
<td align="right">
<?php ColorSelector(ADDR_GRAPH_H_COLOR, DEF_ADDR_GRAPH_H_COLOR, "Highland color") ?>
</td>
<td align="right">
<?php ColorSelector(ADDR_GRAPH_SEL_COLOR, DEF_ADDR_GRAPH_SEL_COLOR, "Selection color") ?>
</td>
</tr>
</table>
</fieldset>
</td></tr>

<tr><td style="padding-bottom: 3pt; padding-top: 3pt;" align="center">
<!--<div style="padding-bottom: 4pt; padding-top: 4pt; text-align: center;">-->
<input type="Submit" name="SetForThisSession" id="SetForThisSession" class="button" value="Set for this session">
<input type="Submit" name="Save" id="Save" class="button" value="Save">
<!--</div>-->
</td></tr>
</table>
</form>

<?php 
include("PageBottom.php");
?>
</body>
</html>
