<?php 
/*----------------------------------------------------------------------\
|        IPAcco - Cisco IP accounting collector and visualizer          |
|                          Version 0.2
|             Copyright (c) 2004-2005 Dmitriy Stepanenko
+-----------------------------------------------------------------------+
| This source file is subject the license, that is bundled with this    |
| package in the file LICENSE.                                          |
| If you did not receive a copy of the Mudropolk license, please send a |
| note to mpolk@kt-privat.donetsk.ua so I can mail you a copy.          |
+-----------------------------------------------------------------------+
| Author: Dmitriy Stepanenko aka Mudropolk <mpolk@kt-privat.donetsk.ua> |
+-----------------------------------------------------------------------+
| $Id: ColorBrightnessPicker.php,v 1.1 2005/05/19 08:48:42 mpolk Exp $
| Color brightness picker image.                                        |
\----------------------------------------------------------------------*/

require_once("Globals.php"); 
require_once("Colors.php"); 

define("IMAGE_WIDTH", 40);
define("IMAGE_HEIGHT", 184);
define("ARROW_LENGTH", 8);
define("ARROW_WIDTH", 12);

$ColorValue = $_GET["Value"];
$ColorRGB = new ColorRGB($ColorValue);
$ColorHLS = new ColorHLS($ColorRGB);

$Img = imagecreate(IMAGE_WIDTH, IMAGE_HEIGHT);
$FrameColor = imagecolorallocate($Img, 96, 96, 96);
$TranspColor = imagecolorallocatealpha($Img, 0, 0, 0, 127);
imagefilledrectangle($Img, 0, 0, IMAGE_WIDTH - 1 , IMAGE_HEIGHT - 1, $TranspColor);
imagerectangle($Img, 0, 0, IMAGE_WIDTH - ARROW_LENGTH - 1, IMAGE_HEIGHT - 1, $FrameColor);

$X0 = IMAGE_WIDTH - ARROW_LENGTH - 1;
$Y0 = round((1.0 - $ColorHLS->L / HLSMAX) * (IMAGE_HEIGHT - 2)) + 1;
$Coords = array($X0, $Y0, 
                $X0 + ARROW_LENGTH, $Y0 - ARROW_WIDTH / 2,
                $X0 + ARROW_LENGTH, $Y0 + ARROW_WIDTH / 2);
imagefilledpolygon($Img, $Coords, 3, $FrameColor);

$X0 = 1; $X1 = IMAGE_WIDTH - ARROW_LENGTH - 2;
for ($i = 1; $i < IMAGE_HEIGHT; $i++) {
    $Y = $i + 1;
    $ColorHLS->L = round((1.0 - $i / (IMAGE_HEIGHT - 2)) * HLSMAX);
    $ColorRGB->FromHLS($ColorHLS);
    $Color = imagecolorexact($Img, $ColorRGB->R, $ColorRGB->G, $ColorRGB->B);
    if ($Color < 0)
        $Color = imagecolorallocate($Img, $ColorRGB->R, $ColorRGB->G, $ColorRGB->B);
    imageline($Img, $X0, $Y, $X1, $Y, $Color);
}//for

header("Content-type: image/png");
imagepng($Img);
imagedestroy($Img);
?>